/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.LuggageUnits;
import com.gridnine.xtrip.common.parsers.model.amadeus.AdditionalServiceData;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.EMDSegment;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class AmadeusFillLuggageSpecificFieldsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        EMDSegment emdSegment = (EMDSegment)airFile.getEmdSegments().get(0);
        AdditionalServiceData asd = (AdditionalServiceData)ctx.getObject((Enum)IBusAmadeusParserContextKeys.ADDITIONAL_SERVICE_DATA);
        if (asd != null) {
            emdSegment = airFile.getEmdSegments().stream().filter(it -> it.getTsmNumber().equals(asd.getMcoNumber().getTsmNumber())).findFirst().orElse(null);
        }
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        String chargeQualifier = emdSegment.getExcessBaggageChargeQualifier();
        product.setLuggageUnits("P".equalsIgnoreCase(chargeQualifier) || "PC".equalsIgnoreCase(chargeQualifier) ? LuggageUnits.PIECE : LuggageUnits.WEIGHT_KG);
        product.setLuggageWeight(Double.valueOf(emdSegment.getExcessBaggageTotalNumber()));
    }
}

