/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.IBusProfileContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

public class AmadeusFillReservationParametersProcessor
extends BaseProcessor {
    private static final String USE_RETAIL_PROFILE = " \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u043a\u043b\u0438\u0435\u043d\u0442\u0430{0} \u0431\u0443\u0434\u0435\u0442 \u0432\u0437\u044f\u0442 \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0440\u043e\u0437\u043d\u0438\u0447\u043d\u043e\u0433\u043e \u043a\u043b\u0438\u0435\u043d\u0442\u0430";

    public void process(MessageContext ctx) throws Exception {
        block10: {
            Iterator iterator;
            AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
            Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.RESERVATION);
            GdsName gdsName = (GdsName)ctx.getObject((Enum)IBusParsersContextKeys.GDS_NAME);
            BookingFile bookingFile = reservation.getBookingFile();
            if (airFile.getPnrDate() != null) {
                bookingFile.setCreateDate(airFile.getPnrDate().getAirCreationDate());
            }
            EntityReference agencyRef = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.AGENCY);
            EntityReference subagencyRef = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.SUBAGENCY);
            EntityReference agentRef = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.AGENT);
            String agentCode = airFile.getServicingCarrier() != null ? airFile.getServicingCarrier().getPnrCreatorAgentSine() : null;
            EntityReference salesPointRef = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.SALES_POINT);
            if (bookingFile.getAgency() == null) {
                bookingFile.setAgency(agencyRef);
            }
            if (bookingFile.getCustomerProfile() == null) {
                if (airFile.getCustomerProfile() != null) {
                    bookingFile.setCustomerProfile(airFile.getCustomerProfile());
                } else {
                    EntityContainer clientCtr = ProfileHelper.getRetailProfileContainer();
                    bookingFile.setCustomerProfile(clientCtr == null ? null : clientCtr.toReference());
                    String customerCode = ctx.getObject((Enum)IBusAmadeusParserContextKeys.CUSTOMER_CODE) != null ? " \u0441 \u043a\u043e\u0434\u043e\u043c " + ctx.getObject((Enum)IBusAmadeusParserContextKeys.CUSTOMER_CODE) + "," : ",";
                    ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)USE_RETAIL_PROFILE, (Object[])new Object[]{customerCode}));
                }
            }
            if (reservation.getBookingAgent() == null) {
                reservation.setBookingAgent(agentRef);
            }
            CommonReservationGdsNameInfoHelper.setBookingAgentDutyCode((Reservation)reservation, (GdsName)gdsName, (String)agentCode);
            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)gdsName, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)airFile.getHeader().getPnrRecordLocator());
            if (airFile.getPnrDate() != null) {
                reservation.setResDate(airFile.getPnrDate().getCreationDate());
            }
            if (reservation.getSalesPoint() == null) {
                reservation.setSalesPoint(salesPointRef);
            }
            reservation.setSubagency(subagencyRef);
            reservation.setType(ReservationType.OFFLINE);
            if (reservation.getBookingFile().getCreateDate() == null && airFile.getPnrDate() != null) {
                reservation.setResDate(MiscUtil.cloneDate((Date)airFile.getPnrDate().getCreationDate()));
            }
            if (!(iterator = airFile.getTickets().iterator()).hasNext()) break block10;
            TicketData ticket = (TicketData)iterator.next();
            Date timelimit = null;
            if (ticket.getTimeLimit() != null) {
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTime(airFile.getPnrDate().getCreationDate());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(ticket.getTimeLimit());
                calendar.set(1, calendar2.get(1));
                timelimit = calendar.getTime();
            }
            reservation.setTimeLimit(timelimit);
        }
    }
}

