/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.FopItem;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.AdditionalServiceData;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang.ArrayUtils;

public class AmadeusFillVoucherSpecificFieldsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BigDecimal sellPrice;
        AirFile file = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        AdditionalServiceData data = (AdditionalServiceData)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.ADDITIONAL_SERVICE_DATA);
        Product voucher = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        voucher.setGdsCurrency(DictHelper.getEquivCurrency());
        BigDecimal voucherTotal = AmadeusParserHelper.getVoucherAmount(file, data.getMcoNumber());
        AirProductHelper.setEquivalentFare((Product)voucher, (BigDecimal)voucherTotal);
        AirProductHelper.setBaseFare((Product)voucher, (Money)SystemHelper.getMoney((BigDecimal)voucherTotal, (String)DictHelper.getEquivCurrency()));
        Product sell = voucher.getRelatedProducts().isEmpty() ? null : (Product)voucher.getRelatedProducts().get(0);
        String relatedNumber = AmadeusParserHelper.getEmdRelatedNumber(file);
        if ((sell == null || sell.getTicketType() == TicketType.FAKE) && "421".equals(voucher.getCarrierNumber()) && this.isVoucher(relatedNumber) || sell != null && sell.getTicketType() != TicketType.FAKE && (sell.getMcoCategory() == MCOCategory.VOUCHER || this.isExchangeWithVoucher(file, sell))) {
            voucher.setMainProductCode(voucher.getCarrierNumber());
            voucher.setMainProductNumber(relatedNumber);
            ArrayList<FopItem> items = new ArrayList<FopItem>();
            ctx.putObject((Enum)IBusParsersContextKeys.FOPS_DATA, items);
            FopItem pi = new FopItem();
            pi.setPaymentType(PaymentType.VOUCHER);
            pi.setAmount(voucherTotal);
            items.add(pi);
            return;
        }
        BigDecimal coeff = BigDecimal.ONE;
        if (sell == null || sell.getTicketType() == TicketType.FAKE) {
            if (sell == null) {
                sell = AirProductHelper.clone((Product)voucher, (boolean)true);
            }
            sell.getRelatedProducts().clear();
            voucher.getRelatedProducts().clear();
            voucher.getRelatedProducts().add(sell);
            sell.setProductCategory(ProductCategory.AIR);
            sell.setSystemNumber(AmadeusParserHelper.getEmdRelatedNumber(file));
            sell.setTicketType(TicketType.FAKE);
            sell.setMcoCategory(null);
            String carrierCode = AmadeusParserHelper.getEmdRelatedCarrierCode(file);
            sell.setCarrierNumber(carrierCode);
            Airline carrier = DictHelper.findAirlineByAnyCode((String)carrierCode, (Date)file.getPnrDate().getCreationDate());
            sell.setCarrier((DictionaryReference)carrier.toReference());
            sellPrice = voucherTotal;
            AirProductHelper.updateFops((Product)sell);
        } else {
            sellPrice = AirProductHelper.getVendorContractRelation((Product)sell).getServiceData().getTotalPrice();
            for (SegmentTariff st : sell.getSegmentTariffs()) {
                SegmentTariff st2 = new SegmentTariff();
                XCloneModelHelper.copy((BaseEntity)st, (BaseEntity)st2, (boolean)true);
                voucher.getSegmentTariffs().add(st2);
            }
            if (voucherTotal.compareTo(sellPrice) < 0) {
                coeff = voucherTotal.divide(sellPrice, 2, RoundingMode.HALF_UP);
            }
            for (Tax tax : sell.getTaxes()) {
                Tax tax2 = new Tax();
                XCloneModelHelper.copy((BaseEntity)tax, (BaseEntity)tax2, (boolean)true);
                tax2.setSegmentTariff(null);
                if (BigDecimal.ONE.compareTo(coeff) != 0) {
                    if (tax2.getAmount() != null && tax2.getAmount().getValue() != null) {
                        tax2.getAmount().setValue(tax2.getAmount().getValue().multiply(coeff).setScale(0, RoundingMode.HALF_UP));
                    }
                    if (tax2.getEquivalentAmount() != null) {
                        tax2.setEquivalentAmount(tax2.getEquivalentAmount().multiply(coeff).setScale(0, RoundingMode.HALF_UP));
                    }
                }
                voucher.getTaxes().add(tax2);
            }
            BigDecimal taxesSum = AirProductTaxHelper.getEquivalentTaxesAmount((Product)voucher);
            BigDecimal fare = voucherTotal.subtract(taxesSum);
            AirProductHelper.setEquivalentFare((Product)voucher, (BigDecimal)fare);
            AirProductHelper.setBaseFare((Product)voucher, (Money)SystemHelper.getMoney((BigDecimal)fare, (String)DictHelper.getEquivCurrency()));
        }
        Product exchange = AirProductHelper.clone((Product)sell, (boolean)true);
        exchange.setPenalty(null);
        exchange.setVendorVatDetalization(null);
        exchange.setVendorVatCalculated(false);
        exchange.setStatus(ProductStatus.EXCHANGE);
        exchange.setIssueDate(voucher.getIssueDate());
        exchange.setCashierCode(voucher.getCashierCode());
        exchange.setCashier(voucher.getCashier());
        exchange.setCompleted(false);
        exchange.setContractRulesApplied(false);
        exchange.setChecked(false);
        sell.setNextProduct(exchange);
        exchange.setPreviousProduct(sell);
        BigDecimal exchangePrice = sellPrice;
        if (voucherTotal.compareTo(sellPrice) < 0) {
            exchange.getTaxes().clear();
            exchange.getFares().clear();
            for (Tax tax : voucher.getTaxes()) {
                Tax tax2 = new Tax();
                XCloneModelHelper.copy((BaseEntity)tax, (BaseEntity)tax2, (boolean)true);
                tax2.setSegmentTariff(null);
                exchange.getTaxes().add(tax2);
            }
            BigDecimal fare = MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)voucher));
            AirProductHelper.setEquivalentFare((Product)exchange, (BigDecimal)fare);
            AirProductHelper.setBaseFare((Product)exchange, (Money)SystemHelper.getMoney((BigDecimal)fare, (String)DictHelper.getEquivCurrency()));
            AirProductHelper.updateFops((Product)exchange);
            exchangePrice = MiscUtil.sum((BigDecimal[])new BigDecimal[]{fare, AirProductTaxHelper.getEquivalentTaxesAmount((Product)exchange)});
        }
        voucher.setPreviousProduct(exchange);
        exchange.setNextProduct(voucher);
        voucher.getRelatedProducts().clear();
        ArrayList<FopItem> exchangeFops = new ArrayList<FopItem>();
        ctx.putObject((Enum)IBusParsersContextKeys.EXCHANGE_FOPS_DATA, exchangeFops);
        FopItem pi = new FopItem();
        pi.setPaymentType(AirProductHelper.getVendorContractRelation((Product)exchange).getFops().stream().filter(it -> it.getType() != null).map(Fop::getType).findFirst().orElse(PaymentType.CASH));
        pi.setAmount(exchangePrice);
        exchangeFops.add(pi);
        if (voucherTotal.compareTo(sellPrice) > 0) {
            BigDecimal delta = MiscUtil.sum((BigDecimal[])new BigDecimal[]{AirProductHelper.getEquivalentFare((Product)voucher), voucher.getPenalty(), AirProductTaxHelper.getEquivalentTaxesAmount((Product)voucher)}).subtract(sellPrice);
            ArrayList<FopItem> items = new ArrayList<FopItem>();
            ctx.putObject((Enum)IBusParsersContextKeys.FOPS_DATA, items);
            FopItem pi2 = new FopItem();
            pi2.setPaymentType(PaymentType.VOUCHER);
            pi2.setAmount(delta);
            items.add(pi2);
        } else {
            ctx.putObject((Enum)IBusParsersContextKeys.FOPS_DATA, null);
        }
    }

    private boolean isVoucher(String relatedNumber) {
        return !TextUtil.isBlank((String)relatedNumber) && !relatedNumber.startsWith("24");
    }

    private boolean isExchangeWithVoucher(AirFile file, Product product) {
        return file.getTickets().stream().map(TicketData::getTicketNumber).filter(TextUtil::nonBlank).anyMatch(ticketNumber -> ticketNumber.equals(product.getSystemNumber()) || ArrayUtils.contains((Object[])AirProductHelper.getConjunctions((Product)product), (Object)ticketNumber));
    }
}

