/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicketIndex;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.SearchResultType;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import com.gridnine.xtrip.server.parsers2.common.Parsers2GeneralHelper;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;

public class AmadeusFindAeroexpressBookingProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        if (AmadeusFindAeroexpressBookingProcessor.findByPnr(ctx)) {
            return;
        }
        EntityContainer ctr = new EntityContainer(BookingFile.class);
        ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER, (Object)ctr);
        Reservation res = new Reservation();
        res.setBookingFile((BookingFile)ctr.getEntity());
        ((BookingFile)ctr.getEntity()).getReservations().add(res);
        ctx.putObject((Enum)IBusParsersContextKeys.RESERVATION, (Object)res);
        ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.NEW);
    }

    private static boolean findByPnr(MessageContext ctx) {
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        String pnr = airFile.getHeader().getPnrRecordLocator();
        if (TextUtil.isBlank((String)pnr)) {
            throw Xeption.forEndUser((String)"\u0432 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 PNR", (Object[])new Object[0]);
        }
        Date creationDate = airFile.getPnrDate().getCreationDate();
        if (creationDate == null) {
            throw Xeption.forEndUser((String)"\u0432 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", (Object[])new Object[0]);
        }
        GdsName gdsName = AmadeusParserHelper.getGdsName(ctx);
        Calendar cal = Calendar.getInstance();
        cal.setTime(creationDate);
        cal.add(1, -2);
        Date lowerBound = cal.getTime();
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(AeroexpressTicketIndex.Property.issueDate.name());
        query.getCriteria().getCriterions().add(SearchCriterion.ilike((String)AeroexpressTicketIndex.Property.recordLocators.name(), (String)String.format("%%%s%%", pnr)));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)AeroexpressTicketIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)AeroexpressTicketIndex.Property.issueDate.name(), (Object)lowerBound));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)AeroexpressTicketIndex.Property.gdsNames.name(), (Object)gdsName), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.isEmpty((String)AeroexpressTicketIndex.Property.gdsNames.name()), SearchCriterion.eq((String)AeroexpressTicketIndex.Property.gdsName.name(), null)})}));
        HashSet<EntityReference> bookings = new HashSet<EntityReference>();
        for (AeroexpressTicketIndex item : EntityStorage.get().search(AeroexpressTicketIndex.class, query).getData()) {
            bookings.add(item.getSource());
        }
        if (bookings.isEmpty()) {
            query = new SearchQuery();
            query.getPreferredProperties().add(AeroexpressTicketIndex.Property.issueDate.name());
            query.getCriteria().getCriterions().add(SearchCriterion.ilike((String)AeroexpressTicketIndex.Property.recordLocator.name(), (String)String.format("%%%s%%", pnr)));
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)AeroexpressTicketIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)AeroexpressTicketIndex.Property.issueDate.name(), (Object)lowerBound));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)AeroexpressTicketIndex.Property.gdsName.name(), (Object)gdsName), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)AeroexpressTicketIndex.Property.gdsName.name(), null), SearchCriterion.isEmpty((String)AeroexpressTicketIndex.Property.gdsNames.name())})}));
            for (AeroexpressTicketIndex item : EntityStorage.get().search(AeroexpressTicketIndex.class, query).getData()) {
                bookings.add(item.getSource());
            }
        }
        if (!bookings.isEmpty()) {
            EntityContainer ctr = EntityStorage.get().resolve((EntityReference)bookings.iterator().next());
            ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER, (Object)ctr);
            for (Reservation item : ((BookingFile)ctr.getEntity()).getReservations()) {
                if (!CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)item, (String)pnr, (GdsName)gdsName)) continue;
                ctx.putObject((Enum)IBusParsersContextKeys.RESERVATION, (Object)item);
                ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.ALREADY_EXISTS);
                return true;
            }
        }
        return Parsers2GeneralHelper.findBookingByPnr((String)pnr, (Date)creationDate, (GdsName)gdsName, (boolean)true, (MessageContext)ctx);
    }
}

