/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductSearchIndex;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHelper;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedProductIndex;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.SearchResultType;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process.AmadeusFindBookingProcessor;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;

public class AmadeusFindBookingByEmdProcessor
extends BaseProcessor {
    private boolean requireMainProduct;

    public void configure(Map<String, String> parameters) {
        this.requireMainProduct = "true".equalsIgnoreCase(parameters.get("requireMainProduct"));
    }

    public void process(MessageContext ctx) throws Exception {
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        String relatedTicketNumber = AmadeusParserHelper.getEmdRelatedNumber(airFile);
        if (TextUtil.isBlank((String)relatedTicketNumber)) {
            AmadeusFindBookingProcessor.findByPnr(ctx);
            if (ctx.getObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER) == null) {
                EntityContainer ctr = new EntityContainer(BookingFile.class);
                ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER, (Object)ctr);
                Reservation res = new Reservation();
                res.setBookingFile((BookingFile)ctr.getEntity());
                ((BookingFile)ctr.getEntity()).getReservations().add(res);
                ctx.putObject((Enum)IBusParsersContextKeys.RESERVATION, (Object)res);
                ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.NEW);
            }
            return;
        }
        Date changeDate = airFile.getPnrDate().getChangeDate();
        if (changeDate == null) {
            throw Xeption.forEndUser((String)"\u0432 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f", (Object[])new Object[0]);
        }
        GdsName gdsName = AmadeusParserHelper.getGdsName(ctx);
        Calendar cal = Calendar.getInstance();
        cal.setTime(changeDate);
        cal.add(1, -2);
        Date lowerBound = cal.getTime();
        SearchQuery query = this.getBaseSearchQuery(relatedTicketNumber, lowerBound);
        query.getCriteria().getCriterions().add(SearchQueryHelper.getGdsNameSearchCriterionForProductSearchIndex((GdsName)gdsName));
        HashSet<EntityReference> bookings = new HashSet<EntityReference>();
        for (ProductSearchIndex item : EntityStorage.get().search(ProductSearchIndex.class, query).getData()) {
            bookings.add(item.getSource());
        }
        if (bookings.size() > 1) {
            throw Xeption.forEndUser((String)"\u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c {0} \u0441 \u0434\u0430\u0442\u043e\u0439 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u043e\u0437\u0434\u043d\u0435\u0435 {1}, \u0432\u044b\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u0445 \u0432 {2}", (Object[])new Object[]{relatedTicketNumber, lowerBound, gdsName});
        }
        if (bookings.isEmpty()) {
            gdsName = GdsName.S7NDC;
            query = this.getBaseSearchQuery(relatedTicketNumber, lowerBound);
            query.getCriteria().getCriterions().add(SearchQueryHelper.getGdsNameSearchCriterionForProductSearchIndex((GdsName)gdsName));
            bookings.addAll(EntityStorage.get().search(ProductSearchIndex.class, query).getData().stream().map(ProductSearchIndex::getSource).collect(Collectors.toList()));
        }
        if (bookings.size() > 1) {
            throw Xeption.forEndUser((String)"\u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c {0} \u0441 \u0434\u0430\u0442\u043e\u0439 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u043e\u0437\u0434\u043d\u0435\u0435 {1}, \u0432\u044b\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u0445 \u0432 {2}", (Object[])new Object[]{relatedTicketNumber, lowerBound, gdsName});
        }
        EntityContainer ctr = null;
        if (!bookings.isEmpty()) {
            ctr = EntityStorage.get().resolve((EntityReference)bookings.iterator().next());
        } else {
            if (AmadeusFindBookingProcessor.findByPnr(ctx)) {
                return;
            }
            gdsName = AmadeusParserHelper.getGdsName(ctx);
            query = new SearchQuery();
            query.getPreferredProperties().add(ArchivedProductIndex.Property.issueDate.name());
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ArchivedProductIndex.Property.productNumber.name(), (Object)relatedTicketNumber));
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ArchivedProductIndex.Property.issueDate.name(), (Object)lowerBound));
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ArchivedProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
            HashSet<EntityReference> archivedBookings = new HashSet<EntityReference>();
            for (ArchivedProductIndex item : EntityStorage.get().search(ArchivedProductIndex.class, query).getData()) {
                archivedBookings.add(item.getSource());
            }
            if (!archivedBookings.isEmpty()) {
                HashSet<EntityReference> toUnarchive = new HashSet<EntityReference>();
                for (EntityReference item : archivedBookings) {
                    EntityContainer bookingContainer = ArchivedBookingHelper.getBookingContainer((ArchivedBooking)((ArchivedBooking)EntityStorage.get().resolve(item).getEntity()));
                    Product prod = this.findProduct((BookingFile)bookingContainer.getEntity(), relatedTicketNumber, lowerBound, gdsName);
                    if (prod == null) {
                        prod = this.findProduct((BookingFile)bookingContainer.getEntity(), relatedTicketNumber, lowerBound, GdsName.S7NDC);
                    }
                    if (prod == null) continue;
                    toUnarchive.add(item);
                }
                if (!toUnarchive.isEmpty()) {
                    if (toUnarchive.size() > 1) {
                        throw Xeption.forEndUser((String)"\u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443 {0} \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0431\u0438\u043b\u0435\u0442\u043e\u0432, \u0432\u044b\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u0445 \u043f\u043e\u0437\u0434\u043d\u0435\u0435 {1} \u0432 {2}", (Object[])new Object[]{relatedTicketNumber, lowerBound, gdsName});
                    }
                    ctr = BookingDao.unarchiveBookingFile((EntityReference)((EntityReference)toUnarchive.iterator().next()));
                    ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0440\u0430\u0437\u0430\u0440\u0445\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0437\u0430\u043a\u0430\u0437 {0}", (Object[])new Object[]{ctr.toReference()}));
                }
            }
        }
        if (ctr == null) {
            gdsName = AmadeusParserHelper.getGdsName(ctx);
            if (this.requireMainProduct) {
                throw Xeption.forEndUser((String)"\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u0430\u0437\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0435\u0433\u043e \u0431\u0438\u043b\u0435\u0442 {0} \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0439 \u043f\u043e\u0437\u0434\u043d\u0435\u0435 {1} \u0432 {2}", (Object[])new Object[]{relatedTicketNumber, lowerBound, gdsName});
            }
            ctr = new EntityContainer(BookingFile.class);
            ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER, (Object)ctr);
            Reservation reservation = new Reservation();
            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)gdsName, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)airFile.getHeader().getPnrRecordLocator());
            ((BookingFile)ctr.getEntity()).getReservations().add(reservation);
            reservation.setBookingFile((BookingFile)ctr.getEntity());
            ctx.putObject((Enum)IBusParsersContextKeys.RESERVATION, (Object)reservation);
            ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.NEW);
            return;
        }
        ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER, (Object)ctr);
        Product prod = this.findProduct((BookingFile)ctr.getEntity(), relatedTicketNumber, lowerBound, gdsName);
        ctx.putObject((Enum)IBusParsersContextKeys.RESERVATION, (Object)prod.getReservation());
        ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.ALREADY_EXISTS);
    }

    private Product findProduct(BookingFile entity, String relatedTicketNumber, Date lowerBound, GdsName gdsName) {
        for (Reservation res : entity.getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                Product prod;
                if (!(bp instanceof Product) || !relatedTicketNumber.equals((prod = (Product)bp).getSystemNumber()) && !ArrayUtils.contains((Object[])AirProductHelper.getConjunctions((Product)prod), (Object)relatedTicketNumber) || prod.getIssueDate() != null && !prod.getIssueDate().after(lowerBound)) continue;
                return prod;
            }
        }
        return null;
    }

    private SearchQuery getBaseSearchQuery(String relatedTicketNumber, Date date) {
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(ProductSearchIndex.Property.issueDate.name());
        query.getPreferredProperties().add(ProductSearchIndex.Property.recordLocators.name());
        query.getPreferredProperties().add(ProductSearchIndex.Property.recordLocator.name());
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.systemNumber.name(), (Object)relatedTicketNumber));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductSearchIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductSearchIndex.Property.issueDate.name(), (Object)date));
        return query;
    }
}

