/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductSearchIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHelper;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedProductIndex;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.SearchResultType;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.MCONumber;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class AmadeusFindRefundedBookingProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        MCONumber mcoNumber;
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        String relatedTicketNumber = ((TicketData)airFile.getTickets().get(0)).getTicketNumber();
        String carrierCode = ((TicketData)airFile.getTickets().get(0)).getValidatingAirlineNumber();
        if (TextUtil.isBlank((String)relatedTicketNumber) && (mcoNumber = AmadeusParserHelper.getMCONumber(airFile)) != null) {
            relatedTicketNumber = mcoNumber.getTicketNumber();
            carrierCode = String.valueOf(mcoNumber.getNumericAirlineCode());
        }
        if (TextUtil.isBlank((String)relatedTicketNumber)) {
            return;
        }
        Date changeDate = airFile.getPnrDate().getChangeDate();
        if (changeDate == null) {
            throw Xeption.forEndUser((String)"\u0432 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f", (Object[])new Object[0]);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(changeDate);
        cal.add(1, -2);
        Date lowerBound = cal.getTime();
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(ProductSearchIndex.Property.issueDate.name());
        query.getPreferredProperties().add(ProductSearchIndex.Property.recordLocators.name());
        query.getPreferredProperties().add(ProductSearchIndex.Property.recordLocator.name());
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.systemNumber.name(), (Object)relatedTicketNumber));
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductSearchIndex.Property.issueDate.name(), (Object)lowerBound));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductSearchIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.status.name(), (Object)ProductStatus.SELL));
        HashSet<EntityReference> bookings = new HashSet<EntityReference>();
        for (ProductSearchIndex item : EntityStorage.get().search(ProductSearchIndex.class, query).getData()) {
            bookings.add(item.getSource());
        }
        if (bookings.size() > 1) {
            throw Xeption.forEndUser((String)"\u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c {0} \u0441 \u0434\u0430\u0442\u043e\u0439 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u043e\u0437\u0434\u043d\u0435\u0435 {1}", (Object[])new Object[]{relatedTicketNumber, lowerBound});
        }
        EntityContainer ctr = null;
        if (!bookings.isEmpty()) {
            ctr = EntityStorage.get().resolve((EntityReference)bookings.iterator().next());
        } else {
            query = new SearchQuery();
            query.getPreferredProperties().add(ArchivedProductIndex.Property.issueDate.name());
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ArchivedProductIndex.Property.productNumber.name(), (Object)relatedTicketNumber));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ArchivedProductIndex.Property.status.name(), (Object)ProductStatus.SELL));
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ArchivedProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ArchivedProductIndex.Property.issueDate.name(), (Object)lowerBound));
            HashSet<EntityReference> archivedBookings = new HashSet<EntityReference>();
            for (Object item : EntityStorage.get().search(ArchivedProductIndex.class, query).getData()) {
                archivedBookings.add(item.getSource());
            }
            if (!archivedBookings.isEmpty()) {
                HashSet<EntityReference> toUnarchive = new HashSet<EntityReference>();
                for (EntityReference item : archivedBookings) {
                    EntityContainer bookingContainer = ArchivedBookingHelper.getBookingContainer((ArchivedBooking)((ArchivedBooking)EntityStorage.get().resolve(item).getEntity()));
                    Product prod = this.findProduct((BookingFile)bookingContainer.getEntity(), relatedTicketNumber, lowerBound);
                    if (prod == null) continue;
                    toUnarchive.add(item);
                }
                if (!toUnarchive.isEmpty()) {
                    if (toUnarchive.size() > 1) {
                        throw Xeption.forEndUser((String)"\u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443 {0} \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0431\u0438\u043b\u0435\u0442\u043e\u0432, \u0432\u044b\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u0445 \u043f\u043e\u0437\u0434\u043d\u0435\u0435 {1}", (Object[])new Object[]{relatedTicketNumber, lowerBound});
                    }
                    ctr = BookingDao.unarchiveBookingFile((EntityReference)((EntityReference)toUnarchive.iterator().next()));
                    ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0440\u0430\u0437\u0430\u0440\u0445\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0437\u0430\u043a\u0430\u0437 {0}", (Object[])new Object[]{ctr.toReference()}));
                }
            }
        }
        if (ctr == null) {
            query = new SearchQuery();
            query.getPreferredProperties().add(ProductSearchIndex.Property.recordLocators.name());
            query.getPreferredProperties().add(ProductSearchIndex.Property.recordLocator.name());
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.systemNumber.name(), (Object)relatedTicketNumber));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.ticketType.name(), (Object)TicketType.FAKE));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.status.name(), (Object)ProductStatus.SELL));
            List indices = EntityStorage.get().search(ProductSearchIndex.class, query).getData();
            if (indices.size() > 1) {
                throw Xeption.forEndUser((String)"\u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0444\u0438\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c {0}", (Object[])new Object[]{relatedTicketNumber});
            }
            if (!indices.isEmpty()) {
                ctr = EntityStorage.get().resolve(((ProductSearchIndex)indices.get(0)).getSource());
                String finalRelatedTicketNumber = relatedTicketNumber;
                String finalCarrierCode = carrierCode;
                ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(p -> p instanceof Product).map(p -> (Product)p).filter(p -> TextUtil.isSame((String)finalRelatedTicketNumber, (String)p.getSystemNumber()) && p.getTicketType() == TicketType.FAKE && p.getStatus() == ProductStatus.SELL).forEach(p -> {
                    p.setCashierCode(finalCarrierCode);
                    Airline carrier = DictHelper.findAirlineByAnyCode((String)finalCarrierCode, (Date)airFile.getPnrDate().getCreationDate());
                    if (carrier != null) {
                        p.setCarrier((DictionaryReference)carrier.toReference());
                    }
                });
                ctx.putObject((Enum)IBusAmadeusParserContextKeys.RELATED_SELL_IS_FAKE, (Object)Boolean.TRUE);
            }
        }
        if (ctr == null) {
            Reservation res = new Reservation();
            ctr = new EntityContainer(BookingFile.class);
            res.setBookingFile((BookingFile)ctr.getEntity());
            Product prod = new Product();
            prod.setSystemNumber(relatedTicketNumber);
            prod.setStatus(ProductStatus.SELL);
            prod.setProductCategory(ProductCategory.AIR);
            prod.setTicketType(TicketType.FAKE);
            prod.setCarrierNumber(carrierCode);
            Airline carrier = DictHelper.findAirlineByAnyCode((String)carrierCode, (Date)airFile.getPnrDate().getCreationDate());
            if (carrier != null) {
                prod.setCarrier((DictionaryReference)carrier.toReference());
            }
            prod.setReservation(res);
            res.getProducts().add(prod);
            ((BookingFile)ctr.getEntity()).getReservations().add(res);
            ctx.putObject((Enum)IBusAmadeusParserContextKeys.RELATED_SELL_IS_FAKE, (Object)Boolean.TRUE);
        }
        ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER, (Object)ctr);
        Product prod = this.findProduct((BookingFile)ctr.getEntity(), relatedTicketNumber, lowerBound);
        if (prod.getNextProduct() != null) {
            ctx.putObject((Enum)IBusParsersContextKeys.RESERVATION, (Object)prod.getReservation());
            ctx.putObject((Enum)IBusBookingContextKeys.PRODUCT, (Object)prod.getNextProduct());
            ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.ALREADY_EXISTS);
            return;
        }
        ctx.putObject((Enum)IBusParsersContextKeys.RESERVATION, (Object)prod.getReservation());
        ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.ALREADY_EXISTS);
    }

    private Product findProduct(BookingFile entity, String relatedTicketNumber, Date lowerBound) {
        for (Reservation res : entity.getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                Product prod;
                if (!(bp instanceof Product) || (prod = (Product)bp).getStatus() != ProductStatus.SELL || !relatedTicketNumber.equals(prod.getSystemNumber()) || prod.getIssueDate() != null && !prod.getIssueDate().after(lowerBound)) continue;
                return prod;
            }
        }
        return null;
    }
}

