/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductSearchIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHelper;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedProductIndex;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.SearchResultType;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.MCONumber;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class AmadeusFindVoidedBookingProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Date creationDate;
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        String pnr = airFile.getHeader().getPnrRecordLocator();
        if (TextUtil.isBlank((String)pnr)) {
            throw Xeption.forEndUser((String)"\u0412 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 PNR", (Object[])new Object[0]);
        }
        List ticketsNumbers = airFile.getTickets().stream().map(TicketData::getTicketNumber).filter(TextUtil::nonBlank).collect(Collectors.toList());
        if (ticketsNumbers.isEmpty()) {
            ticketsNumbers = airFile.getTickets().stream().flatMap(t -> t.getMcoNumbers().stream()).filter(Objects::nonNull).map(MCONumber::getTicketNumber).filter(TextUtil::nonBlank).collect(Collectors.toList());
        }
        if (ticketsNumbers.size() == 0) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u041e\u0431\u043c\u0435\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u043e\u043c\u0435\u0440\u0430 \u0431\u0438\u043b\u0435\u0442\u043e\u0432", (Object[])new Object[0]));
        }
        if ((creationDate = airFile.getHeader().getVoidDate()) == null) {
            throw Xeption.forEndUser((String)"\u0412 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", (Object[])new Object[0]);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(creationDate);
        cal.add(1, -2);
        Date lowerBound = cal.getTime();
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(ProductSearchIndex.Property.issueDate.name());
        query.getCriteria().getCriterions().add(SearchQueryHelper.getRecordLocatorSearchCriterionForProductSearchIndex((String)pnr));
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductSearchIndex.Property.issueDate.name(), (Object)lowerBound));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductSearchIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        query.getCriteria().getCriterions().add(SearchQueryHelper.getGdsNameSearchCriterionForProductSearchIndex((GdsName)AmadeusParserHelper.getGdsName(ctx)));
        if (ticketsNumbers.size() == 1) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.systemNumber.name(), ticketsNumbers.get(0)));
        }
        this.searchBooking(ctx, airFile, pnr, lowerBound, query);
    }

    private void searchBooking(MessageContext ctx, AirFile airFile, String pnr, Date lowerBound, SearchQuery query) throws Exception {
        HashSet<EntityReference> bookings = new HashSet<EntityReference>();
        for (ProductSearchIndex item : EntityStorage.get().search(ProductSearchIndex.class, query).getData()) {
            bookings.add(item.getSource());
        }
        GdsName gdsName = AmadeusParserHelper.getGdsName(ctx);
        if (bookings.size() > 1) {
            throw Xeption.forEndUser((String)L10n.getWithParams((String)"AmadeusParser_FewBookingsFoundForPnrDateGdsName", (Object[])new Object[]{pnr, bookings.size(), lowerBound, gdsName}), (Object[])new Object[0]);
        }
        EntityContainer ctr = null;
        if (!bookings.isEmpty()) {
            ctr = EntityStorage.get().resolve((EntityReference)bookings.iterator().next());
        } else {
            query = new SearchQuery();
            query.getPreferredProperties().add(ArchivedProductIndex.Property.issueDate.name());
            query.getCriteria().getCriterions().add(SearchCriterion.ilike((String)ArchivedProductIndex.Property.recordLocators.name(), (String)String.format("%%%s%%", pnr)));
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ArchivedProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
            HashSet<EntityReference> archivedBookings = new HashSet<EntityReference>();
            for (Object item : EntityStorage.get().search(ArchivedProductIndex.class, query).getData()) {
                archivedBookings.add(item.getSource());
            }
            if (archivedBookings.isEmpty()) {
                query = new SearchQuery();
                query.getPreferredProperties().add(ArchivedProductIndex.Property.issueDate.name());
                query.getCriteria().getCriterions().add(SearchCriterion.ilike((String)ArchivedProductIndex.Property.recordLocator.name(), (String)String.format("%%%s%%", pnr)));
                query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ArchivedProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
                for (Object item : EntityStorage.get().search(ArchivedProductIndex.class, query).getData()) {
                    archivedBookings.add(item.getSource());
                }
            }
            if (!archivedBookings.isEmpty()) {
                HashSet<EntityReference> toUnarchive = new HashSet<EntityReference>();
                for (EntityReference item : archivedBookings) {
                    EntityContainer bookingContainer = ArchivedBookingHelper.getBookingContainer((ArchivedBooking)((ArchivedBooking)EntityStorage.get().resolve(item).getEntity()));
                    for (Reservation res : ((BookingFile)bookingContainer.getEntity()).getReservations()) {
                        String recordLocator = CommonReservationGdsNameInfoHelper.getRecordLocator((Reservation)res, (GdsName)gdsName, (RecordLocatorType)RecordLocatorType.DEFAULT);
                        if (!TextUtil.nonBlank((String)recordLocator) || !recordLocator.contains(pnr) || res.getResDate() != null && !res.getResDate().after(lowerBound)) continue;
                        toUnarchive.add(item);
                    }
                }
                if (!toUnarchive.isEmpty()) {
                    if (toUnarchive.size() > 1) {
                        throw Xeption.forEndUser((String)"\u0434\u043b\u044f pnr {0} \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0439 \u0441 \u0434\u0430\u0442\u043e\u0439 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u043e\u0437\u0434\u043d\u0435\u0435 {1}, \u0441\u0434\u0435\u043b\u0430\u043d\u043d\u044b\u0445 \u0432 {2}", (Object[])new Object[]{pnr, lowerBound, gdsName});
                    }
                    ctr = BookingDao.unarchiveBookingFile((EntityReference)((EntityReference)toUnarchive.iterator().next()));
                    ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0440\u0430\u0437\u0430\u0440\u0445\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0437\u0430\u043a\u0430\u0437 {0}", (Object[])new Object[]{ctr.toReference()}));
                }
            }
        }
        if (ctr == null) {
            Reservation res = new Reservation();
            ctr = new EntityContainer(BookingFile.class);
            res.setBookingFile((BookingFile)ctr.getEntity());
            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)res, (GdsName)gdsName, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)pnr);
            Product prod = new Product();
            prod.setStatus(ProductStatus.SELL);
            prod.setTicketType(TicketType.FAKE);
            String relatedTicketNumber = null;
            String carrierNumber = null;
            MCONumber mcoNumber = AmadeusParserHelper.getMCONumber(airFile);
            if (mcoNumber != null) {
                relatedTicketNumber = mcoNumber.getTicketNumber();
                carrierNumber = String.valueOf(mcoNumber.getNumericAirlineCode());
                prod.setProductCategory(ProductCategory.MCO);
            } else {
                relatedTicketNumber = ((TicketData)airFile.getTickets().get(0)).getTicketNumber();
                carrierNumber = ((TicketData)airFile.getTickets().get(0)).getValidatingAirlineNumber();
                prod.setProductCategory(ProductCategory.AIR);
            }
            prod.setSystemNumber(relatedTicketNumber);
            prod.setCarrierNumber(carrierNumber);
            Airline carrier = DictHelper.findAirlineByAnyCode((String)carrierNumber, (Date)airFile.getPnrDate().getCreationDate());
            if (carrier != null) {
                prod.setCarrier((DictionaryReference)carrier.toReference());
            }
            prod.setReservation(res);
            res.getProducts().add(prod);
            ((BookingFile)ctr.getEntity()).getReservations().add(res);
        }
        ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER, (Object)ctr);
        for (Reservation item : ((BookingFile)ctr.getEntity()).getReservations()) {
            String recordLocator = CommonReservationGdsNameInfoHelper.getRecordLocator((Reservation)item, (GdsName)gdsName, (RecordLocatorType)RecordLocatorType.DEFAULT);
            if (!TextUtil.nonBlank((String)recordLocator) || !recordLocator.contains(pnr)) continue;
            ctx.putObject((Enum)IBusParsersContextKeys.RESERVATION, (Object)item);
            ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.NEW);
            return;
        }
        throw Xeption.forDeveloper((String)"internal error: product found but PNR absent, booking = {0} pnr = {1}", (Object[])new Object[]{ctr.toReference(), pnr});
    }
}

