/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.MCONumber;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.parsers.model.amadeus.TravellerData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.util.Map;

public class AmadeusMergeAeroexpressProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.RESERVATION);
        MCONumber mcoNumber = AmadeusParserHelper.getMCONumber(airFile);
        String ticketNumber = mcoNumber.getTicketNumber();
        ctx.putObject((Enum)IBusParsersContextKeys.TICKET_NUMBER, (Object)ticketNumber);
        ctx.putObject((Enum)IBusParsersContextKeys.SERIAL_NUMBER, (Object)String.valueOf(mcoNumber.getNumericAirlineCode()));
        TicketData ticketData = (TicketData)ctx.getObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA);
        if (ticketData == null) {
            ticketData = (TicketData)airFile.getTickets().get(0);
            ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA, (Object)ticketData);
        }
        Traveller traveller = AmadeusParserHelper.getTravellerOfCurrentBf(ctx) != null ? AmadeusParserHelper.getTravellerOfCurrentBf(ctx) : AmadeusParserHelper.getNewTraveller(ctx);
        for (BaseProduct bp : res.getProducts()) {
            AeroexpressTicket prod;
            if (!(bp instanceof AeroexpressTicket) || !ticketNumber.equals((prod = (AeroexpressTicket)bp).getSystemNumber())) continue;
            ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.FALSE);
            return;
        }
        AeroexpressTicket product = new AeroexpressTicket();
        BookingHelper.addProduct((Reservation)res, (BaseProduct)product);
        product.setTraveller(traveller);
        product.setStatus(ProductStatus.SELL);
        product.setTicketType(TicketType.OWN);
        if (product.getTraveller() == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0434\u043b\u044f \u0431\u0438\u043b\u0435\u0442\u0430 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430", (Object[])new Object[]{ticketNumber}));
        }
        product.setPassengerType(this.getPassengerType(ctx));
        if (product.getPassengerType() == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0434\u043b\u044f \u0431\u0438\u043b\u0435\u0442\u0430 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430, \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d {1}", (Object[])new Object[]{ticketNumber, DictHelper.getAdultPassengerType()}));
        }
        ctx.putObject((Enum)IBusBookingContextKeys.PRODUCT, (Object)product);
        ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.TRUE);
    }

    private DictionaryReference<PassengerType> getPassengerType(MessageContext ctx) {
        TicketData ticketData = (TicketData)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA);
        Map travellers = (Map)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.TRAVELLERS_DATA);
        TravellerData travellerData = (TravellerData)travellers.get(ticketData.getPassenger().getNumberInPNR());
        if (travellerData == null) {
            return null;
        }
        return travellerData.getPassengerType();
    }
}

