/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.AdditionalServiceData;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.MCONumber;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.ArrayUtils;

public class AmadeusMergeEmdProcessor
extends BaseProcessor {
    private MCOCategory mcoCategory;
    private boolean requireMainProduct;
    private boolean fillMainProductValues;

    public void configure(Map<String, String> parameters) {
        this.mcoCategory = MCOCategory.valueOf((String)parameters.get("mcoCategory"));
        this.requireMainProduct = "true".equalsIgnoreCase(parameters.get("requireMainProduct"));
        this.fillMainProductValues = "true".equalsIgnoreCase(parameters.get("fillMainProductValues"));
    }

    public void process(MessageContext ctx) throws Exception {
        Product result;
        String relatedNumber;
        String ticketNumber;
        MCONumber mcoNumber;
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        AdditionalServiceData asd = (AdditionalServiceData)ctx.getObject((Enum)IBusAmadeusParserContextKeys.ADDITIONAL_SERVICE_DATA);
        if (asd != null) {
            mcoNumber = asd.getMcoNumber();
            ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA, (Object)asd.getTicketData());
        } else {
            mcoNumber = AmadeusParserHelper.getMCONumber(airFile);
            TicketData ticketData = (TicketData)ctx.getObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA);
            if (ticketData == null) {
                ticketData = (TicketData)airFile.getTickets().get(0);
                ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA, (Object)ticketData);
            }
        }
        if (mcoNumber == null) {
            ticketNumber = AmadeusParserHelper.getEmdNumber(airFile);
            relatedNumber = AmadeusParserHelper.getEmdRelatedNumber(airFile);
        } else {
            ticketNumber = mcoNumber.getTicketNumber();
            relatedNumber = airFile.getEmdSegments().stream().filter(it -> mcoNumber.getTsmNumber() != null && mcoNumber.getTsmNumber().equals(it.getTsmNumber())).map(it -> it.getIssuedInConnectionWithData() != null ? it.getIssuedInConnectionWithData().getIssuedDocumentNumber() : null).filter(Objects::nonNull).findFirst().orElse(null);
            if (relatedNumber != null && relatedNumber.length() > 10) {
                relatedNumber = relatedNumber.substring(3);
            }
            ctx.putObject((Enum)IBusParsersContextKeys.SERIAL_NUMBER, (Object)String.valueOf(mcoNumber.getNumericAirlineCode()));
        }
        if (TextUtil.isBlank((String)ticketNumber)) {
            throw Xeption.forEndUser((String)"\u0432 \u0444\u0430\u0439\u043b\u0435 {0} \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u043e\u043c\u0435\u0440 EMD", (Object[])new Object[]{ctx.getObject((Enum)IBusParsersContextKeys.FILE_LOCATION)});
        }
        if (TextUtil.isBlank((String)relatedNumber) && this.requireMainProduct) {
            throw Xeption.forEndUser((String)"\u0432 \u0444\u0430\u0439\u043b\u0435 {0} \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u043e\u043c\u0435\u0440 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u0431\u0438\u043b\u0435\u0442\u0430", (Object[])new Object[]{ctx.getObject((Enum)IBusParsersContextKeys.FILE_LOCATION)});
        }
        EntityContainer ctr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        for (Reservation reservation : ((BookingFile)ctr.getEntity()).getReservations()) {
            for (BaseProduct bp2 : reservation.getProducts()) {
                Product prod;
                if (!(bp2 instanceof Product) || !ticketNumber.equals((prod = (Product)bp2).getSystemNumber())) continue;
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"emd {0} \u0443\u0436\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u0430", (Object[])new Object[]{prod.getSystemNumber()}));
                ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.FALSE);
                return;
            }
        }
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.RESERVATION);
        String finalRelatedNumber = relatedNumber;
        Product prod = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(bp -> bp instanceof Product).map(bp -> (Product)bp).filter(p -> p.getStatus() == ProductStatus.SELL && finalRelatedNumber != null && finalRelatedNumber.equals(p.getSystemNumber()) || ArrayUtils.contains((Object[])AirProductHelper.getConjunctions((Product)p), (Object)finalRelatedNumber)).findFirst().orElse(null);
        if (this.requireMainProduct && prod == null) {
            prod = AmadeusParserHelper.createFakeSell(finalRelatedNumber, null, res, null, ctx);
        }
        if (prod != null) {
            result = new Product();
            result.setStatus(ProductStatus.SELL);
            if (this.mcoCategory.equals((Object)MCOCategory.PENALTY) && prod.getNextProduct() != null && prod.getNextProduct().getStatus().equals((Object)ProductStatus.REFUND)) {
                prod = prod.getNextProduct();
            }
            MCOCategory mcoCategoryLocal = null;
            if (this.mcoCategory.equals((Object)MCOCategory.PENALTY) && prod.getPreviousProduct() != null && prod.getPreviousProduct().getStatus().equals((Object)ProductStatus.EXCHANGE) && prod.getNextProduct() == null) {
                mcoCategoryLocal = MCOCategory.REBOOKING;
            } else if (this.mcoCategory.equals((Object)MCOCategory.PENALTY) && prod.getNextProduct() != null && prod.getNextProduct().getStatus() == ProductStatus.EXCHANGE && prod.getNextProduct().getNextProduct() != null && prod.getNextProduct().getNextProduct().getStatus() == ProductStatus.SELL) {
                mcoCategoryLocal = MCOCategory.REBOOKING;
                prod = prod.getNextProduct().getNextProduct();
            }
            result.setMcoCategory(mcoCategoryLocal != null ? mcoCategoryLocal : this.mcoCategory);
            result.setProductCategory(ProductCategory.MCO);
            result.setSystemNumber(ticketNumber);
            result.getRelatedProducts().add(prod);
            result.setTicketType(TicketType.OWN);
            if (this.fillMainProductValues) {
                result.setMainProductNumber(relatedNumber);
                result.setMainProductCode(prod.getCarrier() == null ? null : ((Airline)DictionaryCache.get().resolveReference(prod.getCarrier())).getAirlineNumber());
                if (result.getMainProductCode() == null && airFile.getValidatingCarrier() != null && airFile.getValidatingCarrier().getAirlineNumbericNumber() != null) {
                    result.setMainProductCode(airFile.getValidatingCarrier().getAirlineNumbericNumber().substring(0, 3));
                }
            }
            prod.getReservation().getProducts().add(result);
            result.setReservation(prod.getReservation());
            result.setCarrier(prod.getCarrier());
            result.setCarrierNumber(prod.getCarrierNumber());
            if (prod.getTicketType() == TicketType.FAKE && prod.getTraveller() == null) {
                Traveller traveller = AmadeusParserHelper.getTravellerOfCurrentBf(ctx);
                if (traveller == null) {
                    traveller = AmadeusParserHelper.getNewTraveller(ctx);
                }
                ProductHandler.of((BaseProduct)prod).setOrReplaceTraveller((BaseProduct)prod, traveller);
            }
            result.setTraveller(prod.getTraveller());
            ctx.putObject((Enum)IBusBookingContextKeys.PRODUCT, (Object)result);
            ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.TRUE);
            return;
        }
        if (this.requireMainProduct) {
            throw Xeption.forEndUser((String)"\u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 EMD {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0431\u0438\u043b\u0435\u0442 \u0441 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c", (Object[])new Object[]{ticketNumber});
        }
        result = new Product();
        result.setStatus(ProductStatus.SELL);
        result.setMcoCategory(this.mcoCategory);
        result.setProductCategory(ProductCategory.MCO);
        result.setSystemNumber(ticketNumber);
        if (this.fillMainProductValues) {
            result.setMainProductNumber(relatedNumber);
            if (airFile.getValidatingCarrier() == null || airFile.getValidatingCarrier().getAirlineNumbericNumber() == null) {
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u0434 \u0432\u0430\u043b\u0438\u0434\u0438\u0440\u0443\u044e\u0449\u0435\u0433\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430", (Object[])new Object[0]));
            } else {
                result.setMainProductCode(airFile.getValidatingCarrier().getAirlineNumbericNumber().substring(0, 3));
            }
        }
        result.setTicketType(TicketType.OWN);
        res.getProducts().add(result);
        result.setReservation(res);
        result.setTraveller(AmadeusParserHelper.getTravellerOfCurrentBf(ctx) != null ? AmadeusParserHelper.getTravellerOfCurrentBf(ctx) : AmadeusParserHelper.getNewTraveller(ctx));
        String validatingAirlineNumber = Integer.toString(mcoNumber.getNumericAirlineCode());
        result.setCarrierNumber(validatingAirlineNumber);
        Airline airline = DictHelper.findAirlineByAnyCode((String)validatingAirlineNumber);
        if (airline != null) {
            result.setCarrier((DictionaryReference)airline.toReference());
            if (result.getCarrierNumber() == null) {
                result.setCarrierNumber(airline.getAirlineNumber());
            }
        } else {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u0430\u043b\u0438\u0434\u0438\u0440\u0443\u044e\u0449\u0443\u044e \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044e \u043f\u043e \u043a\u043e\u0434\u0443 {1}", (Object[])new Object[]{mcoNumber.getTicketNumber(), validatingAirlineNumber}));
        }
        ctx.putObject((Enum)IBusBookingContextKeys.PRODUCT, (Object)result);
        ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.TRUE);
    }
}

