/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.SearchResultType;
import com.gridnine.xtrip.common.parsers.model.amadeus.AdditionalServiceData;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.MCOExchangeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.util.Map;

public class AmadeusMergeExchangeMCOProcessor
extends BaseProcessor {
    private MCOCategory mcoCategory;

    public void configure(Map<String, String> parameters) {
        this.mcoCategory = MCOCategory.valueOf((String)parameters.get("mcoCategory"));
    }

    public void process(MessageContext ctx) throws Exception {
        String carrierCode;
        String previousTicketNumber;
        AdditionalServiceData additionalServiceData = (AdditionalServiceData)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.ADDITIONAL_SERVICE_DATA);
        ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA, (Object)additionalServiceData.getTicketData());
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.RESERVATION);
        String ticketNumber = additionalServiceData.getMcoNumber().getTicketNumber();
        if (ticketNumber != null) {
            for (BaseProduct bp : res.getProducts()) {
                Product prod;
                if (!(bp instanceof Product) || (prod = (Product)bp).getStatus() != ProductStatus.SELL || !ticketNumber.equals(prod.getSystemNumber())) continue;
                ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.FALSE);
                return;
            }
        }
        Product sell = null;
        MCOExchangeNumber mcoExchangeNumber = additionalServiceData.getTicketData().getMcoExchangeNumbers().stream().filter(it -> it.getTsmNumber() != null && it.getTsmNumber().equals(additionalServiceData.getMcoNumber().getTsmNumber())).findFirst().orElse(null);
        if (mcoExchangeNumber == null) {
            throw Xeption.forDeveloper((String)("unable to find exchange number for " + additionalServiceData.getMcoNumber().getTicketNumber()), (Object[])new Object[0]);
        }
        if (mcoExchangeNumber.getInExchangeForTicketNumber() != null) {
            previousTicketNumber = mcoExchangeNumber.getInExchangeForTicketNumber();
            carrierCode = mcoExchangeNumber.getInExchangeForCarrierCode();
        } else {
            previousTicketNumber = mcoExchangeNumber.getOriginalIssueTicketNumber();
            carrierCode = mcoExchangeNumber.getOriginalIssueCarrierCode();
        }
        if (TextUtil.isBlank((String)previousTicketNumber)) {
            throw Xeption.forDeveloper((String)("unable to find previous ticket number number for " + additionalServiceData.getMcoNumber().getTicketNumber()), (Object[])new Object[0]);
        }
        for (BaseProduct bp : res.getProducts()) {
            Product prod;
            if (!(bp instanceof Product) || (prod = (Product)bp).getStatus() != ProductStatus.SELL || !prod.getSystemNumber().equals(previousTicketNumber)) continue;
            sell = prod;
        }
        if (sell == null) {
            sell = AmadeusParserHelper.createFakeSell(previousTicketNumber, carrierCode, res, this.mcoCategory, ctx);
        }
        String pnr = (String)ctx.getObject((Enum)IBusParsersContextKeys.PNR);
        GdsName gdsName = AmadeusParserHelper.getGdsName(ctx);
        Product exchange = AmadeusParserHelper.createExchange(sell, this.mcoCategory);
        if (TextUtil.nonBlank((String)pnr) && !CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)sell.getReservation(), (String)pnr, (GdsName)gdsName)) {
            AmadeusParserHelper.split(exchange, pnr, gdsName);
        }
        ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.NEW);
        ctx.putObject((Enum)IBusBookingContextKeys.PRODUCT, (Object)exchange);
        ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.TRUE);
    }
}

