/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.parsers.model.SearchResultType;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.util.Collection;

public class AmadeusMergeExchangeProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String carrierCode;
        String previousTicketNumber;
        TicketData ticketData = (TicketData)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA);
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.RESERVATION);
        Product exchange = res.getProducts().stream().filter(bp -> bp instanceof Product).map(bp -> (Product)bp).filter(p -> p.getStatus() == ProductStatus.SELL && ticketData.getTicketNumber().equals(p.getSystemNumber())).findFirst().orElse(null);
        if (exchange != null && exchange.getTicketType() != TicketType.FAKE) {
            if (exchange.getPreviousProduct() == null) {
                Message msg = SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0411\u0438\u043b\u0435\u0442 {0}, \u0432\u044b\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u0439 \u0432 \u043e\u0431\u043c\u0435\u043d, \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u0432 \u0437\u0430\u043a\u0430\u0437\u0435 \u043a\u0430\u043a \u043f\u0435\u0440\u0432\u043e\u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0434\u0430\u0436\u0430. \u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0440\u0443\u0447\u043d\u0430\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430.", (Object[])new Object[]{ticketData.getTicketNumber()});
                ctx.addMessage(msg);
                BaseExchangeDocument doc = (BaseExchangeDocument)ctx.getObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT);
                Message msg2 = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0418\u043c\u043f\u043e\u0440\u0442 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 {0} \u043d\u0435 \u043f\u0440\u0438\u0432\u0435\u043b \u043a \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0437\u0430\u043a\u0430\u0437\u0430", (Object[])new Object[]{doc.getName()});
                ctx.addMessage(msg2);
                doc.setStatus(ProcessingStatus.ERROR);
            }
            ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.FALSE);
            return;
        }
        Product sell = null;
        AirFile file = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        if (file.getInExchangeForTicketNumber() != null) {
            previousTicketNumber = file.getInExchangeForTicketNumber();
            carrierCode = file.getInExchangeForCarrierCode();
        } else if (ticketData.getHandTicketNumber() != null) {
            previousTicketNumber = ticketData.getHandTicketNumber();
            carrierCode = ticketData.getValidatingAirlineNumber();
        } else {
            previousTicketNumber = file.getOriginalIssueTicketNumber();
            carrierCode = file.getOriginalIssueCarrierCode();
        }
        for (BaseProduct bp2 : res.getProducts()) {
            Product prod;
            if (!(bp2 instanceof Product) || (prod = (Product)bp2).getStatus() != ProductStatus.SELL || prod.getSystemNumber() == null || !prod.getSystemNumber().equals(previousTicketNumber)) continue;
            sell = prod;
        }
        if (sell == null) {
            MCOCategory mcoCategory = null;
            if (ticketData.getEndorsement() != null) {
                if (ticketData.getEndorsement().contains("EXCH VCR")) {
                    mcoCategory = MCOCategory.VOUCHER;
                }
                sell = AmadeusParserHelper.createFakeSell(previousTicketNumber, carrierCode, res, mcoCategory, ctx);
            }
        }
        String pnr = (String)ctx.getObject((Enum)IBusParsersContextKeys.PNR);
        GdsName gdsName = AmadeusParserHelper.getGdsName(ctx);
        if (exchange == null) {
            exchange = AmadeusParserHelper.createExchange(sell, null);
        } else {
            AmadeusParserHelper.linkFakeExchange(sell, exchange, null);
            Collection emds = AirProductHelper.getMcoByRelatedProduct((Product)exchange);
            if (!emds.isEmpty()) {
                ctx.putObject((Enum)IBusAmadeusParserContextKeys.RELATED_EMDS, (Object)emds);
            }
        }
        if (TextUtil.nonBlank((String)pnr) && !CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)sell.getReservation(), (String)pnr, (GdsName)gdsName)) {
            AmadeusParserHelper.split(exchange, pnr, gdsName);
        }
        ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.NEW);
        ctx.putObject((Enum)IBusBookingContextKeys.PRODUCT, (Object)exchange);
        ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.TRUE);
    }
}

