/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.MCONumber;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.parsers.model.amadeus.TravellerData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.util.Map;

public class AmadeusMergeInsuranceAccidentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.RESERVATION);
        MCONumber mcoNumber = AmadeusParserHelper.getMCONumber(airFile);
        String ticketNumber = null;
        if (mcoNumber != null) {
            ticketNumber = mcoNumber.getTicketNumber();
            ctx.putObject((Enum)IBusParsersContextKeys.SERIAL_NUMBER, (Object)String.valueOf(mcoNumber.getNumericAirlineCode()));
        }
        ctx.putObject((Enum)IBusParsersContextKeys.TICKET_NUMBER, (Object)ticketNumber);
        TicketData ticketData = (TicketData)ctx.getObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA);
        if (ticketData == null) {
            ticketData = (TicketData)airFile.getTickets().get(0);
            ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA, (Object)ticketData);
        }
        EntityContainer ctr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        for (Reservation reservation : ((BookingFile)ctr.getEntity()).getReservations()) {
            for (BaseProduct bp : reservation.getProducts()) {
                InsuranceAccident prod;
                if (!(bp instanceof InsuranceAccident) || !(prod = (InsuranceAccident)bp).getSystemNumber().equals(ticketNumber)) continue;
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0421\u0442\u0440\u0430\u0445\u043e\u0432\u043a\u0430 {0} \u0443\u0436\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u0430", (Object[])new Object[]{prod.getSystemNumber()}));
                ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.FALSE);
                return;
            }
        }
        InsuranceAccident result = new InsuranceAccident();
        result.setStatus(ProductStatus.SELL);
        result.setReservation(res);
        if (res != null) {
            res.getProducts().add(result);
        }
        result.setSystemNumber(ticketNumber);
        result.setTicketType(TicketType.OWN);
        Traveller traveller = AmadeusParserHelper.getTravellerOfCurrentBf(ctx) != null ? AmadeusParserHelper.getTravellerOfCurrentBf(ctx) : AmadeusParserHelper.getNewTraveller(ctx);
        String passengerUID = null;
        if (this.getPassenger(ctx) != null) {
            passengerUID = this.getPassenger(ctx).getUid();
        }
        result.setTravellerUid(passengerUID);
        ctx.putObject((Enum)IBusBookingContextKeys.PRODUCT, (Object)result);
        ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.TRUE);
    }

    private Traveller getPassenger(MessageContext ctx) {
        TicketData ticketData = (TicketData)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA);
        Map travellers = (Map)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.TRAVELLERS_DATA);
        TravellerData travellerData = (TravellerData)travellers.get(ticketData.getPassenger().getNumberInPNR());
        if (travellerData == null) {
            return null;
        }
        return travellerData.getTraveller();
    }
}

