/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.MCONumber;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.util.Collections;
import java.util.List;

public class AmadeusMergeRefundProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Product prod;
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        TicketData ticketData = (TicketData)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA);
        String ticketNumber = ticketData.getTicketNumber();
        MCONumber mcoNumber = AmadeusParserHelper.getMCONumber(airFile);
        if (TextUtil.isBlank((String)ticketNumber) && mcoNumber != null) {
            ticketNumber = mcoNumber.getTicketNumber();
        }
        if (TextUtil.isBlank((String)ticketNumber)) {
            throw Xeption.forEndUser((String)"\u0432 \u0444\u0430\u0439\u043b\u0435 {0} \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u043e\u043c\u0435\u0440 \u0431\u0438\u043b\u0435\u0442\u0430", (Object[])((Object[])ctx.getObject((Enum)IBusParsersContextKeys.FILE_LOCATION)));
        }
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.RESERVATION);
        for (BaseProduct bp : res.getProducts()) {
            if (!(bp instanceof Product) || (prod = (Product)bp).getStatus() != ProductStatus.REFUND || !this.hasAppropritedSystemNumber(prod.getSystemNumber(), prod.getConjCount(), ticketNumber)) continue;
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0431\u0438\u043b\u0435\u0442 {0} \u0443\u0436\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d", (Object[])new Object[]{prod.getSystemNumber()}));
            ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.FALSE);
            return;
        }
        for (BaseProduct bp : res.getProducts()) {
            if (!(bp instanceof Product) || (prod = (Product)bp).getStatus() != ProductStatus.SELL || !this.hasAppropritedSystemNumber(prod.getSystemNumber(), prod.getConjCount(), ticketNumber)) continue;
            if (prod.getTraveller() == null) {
                ProductHandler.of((BaseProduct)prod).setOrReplaceTraveller((BaseProduct)prod, AmadeusParserHelper.getTravellerOfCurrentBf(ctx));
            }
            Product result = AirProductHelper.clone((Product)prod, (boolean)true);
            for (AirProductContractRelationData relation : (List)result.getValue("contractRelations")) {
                relation.getFops().clear();
            }
            result.setVendorVatDetalization(null);
            result.setVendorVatCalculated(false);
            result.setContractRulesApplied(false);
            result.setChecked(false);
            result.setBspCommissionRate(null);
            result.setBspCommissionValue(null);
            result.setPreviousProduct(prod);
            prod.setNextProduct(result);
            AirProductHelper.clearCommissions((Product)result);
            this.checkRelatedPenaltyMco(prod, result);
            result.setStatus(ProductStatus.REFUND);
            ctx.putObject((Enum)IBusBookingContextKeys.PRODUCT, (Object)result);
            ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.TRUE);
            return;
        }
        throw Xeption.forEndUser((String)"\u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0431\u0438\u043b\u0435\u0442 \u0441 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c", (Object[])new Object[]{ticketNumber});
    }

    private boolean hasAppropritedSystemNumber(String systemNumber, int conjCount, String ticketNumber) {
        if (TextUtil.isBlank((String)systemNumber)) {
            return false;
        }
        if (ticketNumber.equals(systemNumber)) {
            return true;
        }
        for (int n = 1; n <= conjCount; ++n) {
            if (!FormattedNumberUtil.add((String)systemNumber, (long)1L).equals(systemNumber)) continue;
            return true;
        }
        return false;
    }

    private void checkRelatedPenaltyMco(Product sell, Product refund) {
        for (Product mco : AirProductHelper.getMcoByRelatedProduct((Product)sell)) {
            if (mco.getMcoCategory() != MCOCategory.PENALTY || mco.getRelatedProducts().contains(refund)) continue;
            Collections.replaceAll(mco.getRelatedProducts(), sell, refund);
        }
    }
}

