/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.TravellerData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.util.List;
import java.util.Map;

public class AmadeusMergeTravellersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map result = (Map)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.TRAVELLERS_DATA);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        for (TravellerData travellerData : result.values()) {
            Traveller traveller = this.findTravellerByPassport(travellerData.getTraveller(), ((BookingFile)bookingCtr.getEntity()).getTravellers());
            if (traveller != null) {
                this.updateTraveller(traveller, travellerData.getTraveller());
                continue;
            }
            traveller = this.findTravellerByName(travellerData.getTraveller(), ((BookingFile)bookingCtr.getEntity()).getTravellers());
            if (traveller != null) {
                this.updateTraveller(traveller, travellerData.getTraveller());
                continue;
            }
            ((BookingFile)bookingCtr.getEntity()).getTravellers().add(travellerData.getTraveller());
        }
    }

    private Traveller findTravellerByName(Traveller fromAir, List<Traveller> travellers) {
        return travellers.stream().filter(t -> AmadeusParserHelper.isTravellersEqualsByName(t, fromAir)).findFirst().orElse(null);
    }

    private void updateTraveller(Traveller existing, Traveller fromAir) {
        fromAir.setUid(existing.getUid());
        if (existing.getBirthday() == null) {
            existing.setBirthday(fromAir.getBirthday());
        }
        if (existing.getGender() == null) {
            existing.setGender(fromAir.getGender());
        }
        if (existing.getPassport() == null) {
            existing.setPassport(fromAir.getPassport());
        }
    }

    private Traveller findTravellerByPassport(Traveller fromAir, List<Traveller> travellers) {
        return travellers.stream().filter(t -> AmadeusParserHelper.isTravellersEqualsByPassport(t, fromAir)).findFirst().orElse(null);
    }
}

