/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.parsers.model.amadeus.ValidatingCarrier;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers2.common.OrganizationDataProcessor;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class AmadeusOrganizationDataProcessor
extends OrganizationDataProcessor {
    public void filterBlankOwnerByAirlineCode(List<ValidatorIndex> data, String systemNumber, GdsName gdsName, boolean bspTicket, boolean tchTicket, Date issueDate, MessageContext ctx) {
        if (GdsName.S7NDC != gdsName && (bspTicket || tchTicket)) {
            return;
        }
        TicketData ticketData = (TicketData)ctx.getObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA);
        AirFile airFile = (AirFile)ctx.getObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        String airlineNumber = Optional.ofNullable(ticketData).map(TicketData::getValidatingAirlineNumber).orElse(null);
        String airlineCode = Optional.ofNullable(airFile).map(AirFile::getValidatingCarrier).map(ValidatingCarrier::getAirlineCode).orElse(null);
        if (TextUtil.nonBlank((String)airlineNumber)) {
            data.removeIf(index -> {
                Airline airline = Optional.ofNullable(EntityStorage.get().resolve(index.getBlankOwner())).map(item -> ((Organization)item.getEntity()).getAirline()).map(item -> (Airline)DictionaryCache.get().resolveReference(item)).orElse(null);
                if (airline != null) {
                    return !airlineNumber.equalsIgnoreCase(airline.getAirlineNumber()) || !DictHelper.isAirlineFitByDates((Airline)airline, (Date)issueDate);
                }
                return true;
            });
        } else if (TextUtil.nonBlank((String)airlineCode)) {
            data.removeIf(index -> {
                DictionaryReference airlineRef = Optional.ofNullable(EntityStorage.get().resolve(index.getBlankOwner())).map(item -> ((Organization)item.getEntity()).getAirline()).orElse(null);
                Airline airline = Optional.ofNullable(airlineRef).map(item -> (Airline)DictionaryCache.get().resolveReference(item)).orElse(null);
                if (airline != null) {
                    return !airlineCode.equals(DictHelper.getCodeVariant((DictionaryReference)airlineRef, (CodeSystem[])new CodeSystem[]{CodeSystem.IATA})) || !DictHelper.isAirlineFitByDates((Airline)airline, (Date)issueDate);
                }
                return true;
            });
        }
    }

    protected String getFewValidatorsFoundMessage(OrganizationDataProcessor.OfficeIdType officeIdType) {
        if (officeIdType == OrganizationDataProcessor.OfficeIdType.TICKETING) {
            return "AmadeusParser_TicketingFewValidatorsFound";
        }
        if (officeIdType == OrganizationDataProcessor.OfficeIdType.BOOKING) {
            return "AmadeusParser_BookingFewValidatorsFound";
        }
        return super.getFewValidatorsFoundMessage(officeIdType);
    }

    protected String getNoValidatorFoundMessage(OrganizationDataProcessor.OfficeIdType officeIdType) {
        if (officeIdType == OrganizationDataProcessor.OfficeIdType.TICKETING) {
            return "AmadeusParser_TicketingNoValidatorFound";
        }
        if (officeIdType == OrganizationDataProcessor.OfficeIdType.BOOKING) {
            return "AmadeusParser_BookingNoValidatorFound";
        }
        return super.getNoValidatorFoundMessage(officeIdType);
    }

    protected String getValidatorFoundWithEmptyBlankOwnerMessage(OrganizationDataProcessor.OfficeIdType officeIdType) {
        if (officeIdType == OrganizationDataProcessor.OfficeIdType.TICKETING) {
            return "AmadeusParser_TicketingValidatorFoundWithEmptyBlankOwner";
        }
        if (officeIdType == OrganizationDataProcessor.OfficeIdType.BOOKING) {
            return "AmadeusParser_BookingValidatorFoundWithEmptyBlankOwner";
        }
        return super.getValidatorFoundWithEmptyBlankOwnerMessage(officeIdType);
    }
}

