/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.BookingAirlineBonusCard;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.Passenger;
import com.gridnine.xtrip.common.parsers.model.amadeus.ServiceRequest;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.parsers.model.amadeus.TravellerData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AmadeusParseTravellerDataProcessor
extends BaseProcessor {
    private final DateFormat dateFormat = new SimpleDateFormat("ddMMMyy", Locale.US);
    private final Pattern travellerNamePattern = Pattern.compile("(.*) (MR|MRS)");
    private final Pattern cardNumberPattern = Pattern.compile("[0-9]+");
    private static List<String> CHILD_PASSPORT_TYPES = Arrays.asList(PassengerTypeValue.CHILD.name(), PassengerTypeValue.CHILD_UNACCOMPANIED.name(), PassengerTypeValue.INFANT.name(), PassengerTypeValue.INFANT_WITH_SITE.name());

    public void process(MessageContext ctx) throws Exception {
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        List<TravellerData> travellers = this.getTravellerData(airFile, ctx);
        Map<Integer, TravellerData> result = this.convertToMap(travellers);
        ctx.putObject((Enum)IBusAmadeusParserContextKeys.TRAVELLERS_DATA, result);
    }

    private Map<Integer, TravellerData> convertToMap(List<TravellerData> travellers) {
        HashMap<Integer, TravellerData> result = new HashMap<Integer, TravellerData>();
        for (TravellerData traveller : travellers) {
            result.put(traveller.getIndex(), traveller);
        }
        return result;
    }

    private List<TravellerData> getTravellerData(AirFile airFile, MessageContext ctx) {
        ArrayList<TravellerData> result = new ArrayList<TravellerData>();
        for (TicketData ticketData : airFile.getTickets()) {
            Passenger passenger = ticketData.getPassenger();
            if (passenger.getName() != null && passenger.getName().toLowerCase().contains("deposit")) continue;
            TravellerData travellerData = new TravellerData();
            Traveller traveller = new Traveller();
            String travellerName = this.cleanUpName(passenger.getName());
            traveller.setName(travellerName);
            traveller.setCyrillicName(TextUtil.translit((String)travellerName, (boolean)false));
            traveller.setNameInGds(passenger.getName());
            travellerData.setPassengerType(this.getPassengerType(passenger.getType()));
            travellerData.setIndex(passenger.getNumberInPNR());
            travellerData.setTraveller(traveller);
            for (ServiceRequest serviceRequest : ticketData.getServiceRequests()) {
                if ("DOCS".equals(serviceRequest.getSsrType())) {
                    if (!serviceRequest.getPassengerNumbers().contains(passenger.getNumberInPNR()) || this.isInfant(serviceRequest.getMessage()) != DictHelper.isInfantPassengerTypeCategory((DictionaryReference)travellerData.getPassengerType())) continue;
                    this.processDocsRequestMessage(travellerData.getTraveller(), serviceRequest.getMessage(), (DictionaryReference<PassengerType>)travellerData.getPassengerType(), ctx);
                    continue;
                }
                if (!"FQTV".equals(serviceRequest.getSsrType()) || !serviceRequest.getPassengerNumbers().contains(passenger.getNumberInPNR())) continue;
                this.processFqtvRequestMessage(travellerData.getTraveller(), serviceRequest, ctx);
            }
            result.add(travellerData);
        }
        return result;
    }

    private void processFqtvRequestMessage(Traveller traveller, ServiceRequest serviceRequest, MessageContext ctx) {
        BookingAirlineBonusCard card = new BookingAirlineBonusCard();
        card.setValid("HK".equals(serviceRequest.getStatusCode()));
        String message = serviceRequest.getMessage();
        if (!TextUtil.isBlank((String)message)) {
            String cardOwnerCode = message.substring(0, 2);
            Airline airline = DictHelper.findAirlineByAnyCode((String)cardOwnerCode);
            if (airline != null) {
                card.setAirline((DictionaryReference)airline.toReference());
            } else {
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0410\u041a \u0431\u043e\u043d\u0443\u0441\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u044b \u043f\u043e \u043a\u043e\u0434\u0443 {0}", (Object[])new Object[]{cardOwnerCode}));
            }
            String cardNumber = message.substring(2);
            Matcher matcher = this.cardNumberPattern.matcher(cardNumber);
            if (matcher.find()) {
                card.setNumber(matcher.group());
            } else {
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u043e\u043c\u0435\u0440 \u0431\u043e\u043d\u0443\u0441\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u044b", (Object[])new Object[0]));
            }
        }
        traveller.getAirlineBonusCards().add(card);
    }

    private String cleanUpName(String name) {
        String result = name.replace("/", " ");
        Matcher m = this.travellerNamePattern.matcher(result);
        if (m.find()) {
            return m.group(1);
        }
        return result;
    }

    private void processDocsRequestMessage(Traveller traveller, String requestMessage, DictionaryReference<PassengerType> passengerType, MessageContext ctx) {
        String[] messageParts = requestMessage.split("/");
        Passport passport = new Passport();
        passport.setFirstName(messageParts[8]);
        passport.setLastName(messageParts[7]);
        Gender gender = this.getGender(messageParts[5]);
        passport.setGender(gender);
        traveller.setGender(gender);
        try {
            Date birthday = this.parseDate(messageParts[4]);
            passport.setBirthday(birthday);
            traveller.setBirthday(birthday);
            passport.setExpired(this.parseDate(messageParts[6]));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        DictionaryReference<Country> citizenship = this.findCountry(messageParts[1], ctx);
        passport.setType(this.getPassportType(messageParts[0], messageParts[2], citizenship, passengerType));
        passport.setCitizenship(citizenship);
        passport.setNumber(messageParts[2]);
        passport.setOriginCountry(this.findCountry(messageParts[3], ctx));
        traveller.setPassport(passport);
    }

    private DictionaryReference<Country> findCountry(String code, MessageContext ctx) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        Set countries = DictionaryCache.get().lookup(Country.class, code, new String[]{CodeSystem.ISO.name(), CodeSystem.IATA.name(), CodeSystem.ISO_ALPHA3.name()});
        if (countries.isEmpty()) {
            countries = DictionaryCache.get().lookup(Country.class, code, new String[]{CodeSystem.EXPRESS.name()});
        }
        if (countries.isEmpty()) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0441\u0442\u0440\u0430\u043d\u0443 (\u0432 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0435) \u043f\u043e \u043a\u043e\u0434\u0443 {0}", (Object[])new Object[]{code}));
            return null;
        }
        Country country = (Country)countries.iterator().next();
        if (countries.size() > 1) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0441\u0442\u0440\u0430\u043d (\u0432 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0435) \u043f\u043e \u043a\u043e\u0434\u0443 {0}, \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0430 {1}", (Object[])new Object[]{code, country.toReference()}));
        }
        return country.toReference();
    }

    private PassportType getPassportType(String type, String number, DictionaryReference<Country> citizenship, DictionaryReference<PassengerType> passengerType) {
        if (type.equals("P")) {
            Country citizenshipCountry = (Country)DictionaryCache.get().resolveReference(citizenship);
            if (passengerType != null && citizenshipCountry != null && citizenshipCountry.isDomestic()) {
                if (CHILD_PASSPORT_TYPES.contains(passengerType.getCode())) {
                    return PassportType.BIRTHDAY_NOTIFICATION;
                }
                if (number.length() == 10) {
                    return PassportType.INTERNAL;
                }
                if (number.length() == 9) {
                    return PassportType.FOREIGN;
                }
            }
            return PassportType.PASSPORT;
        }
        if ("M".equals(type)) {
            return PassportType.MILITARYID;
        }
        if ("N".equals(type)) {
            return PassportType.NATURALIZATIONCERTIFICATE;
        }
        if ("F".equals(type)) {
            return PassportType.OTHER;
        }
        if ("T".equals(type)) {
            return PassportType.TRAVELDOCUMENT;
        }
        if ("V".equals(type)) {
            return PassportType.BORDERCROSSINGCARD;
        }
        if ("A".equals(type)) {
            return PassportType.ALIENRESIDENTCARD;
        }
        if ("I".equals(type)) {
            return PassportType.IDENTITYCARD;
        }
        if ("C".equals(type)) {
            return PassportType.PERMANENTRESIDENTCARD;
        }
        return null;
    }

    private Gender getGender(String line) {
        if (line.equals("M") || line.equals("MI")) {
            return Gender.MALE;
        }
        if (line.equals("F") || line.equals("FI")) {
            return Gender.FEMALE;
        }
        return null;
    }

    private boolean isInfant(String requestMessage) {
        String[] messageParts = requestMessage.split("/");
        String line = messageParts[5];
        return line.equals("MI") || line.equals("FI");
    }

    private DictionaryReference<PassengerType> getPassengerType(String type) {
        if ("ADT".equals(type)) {
            return DictHelper.getAdultPassengerType();
        }
        if ("INF".equals(type)) {
            return DictHelper.getInfantPassengerType();
        }
        if ("CHD".equals(type)) {
            return DictHelper.getChildPassengerType();
        }
        return DictHelper.getAdultPassengerType();
    }

    private Date parseDate(String string) throws ParseException {
        if (TextUtil.isBlank((String)string)) {
            return null;
        }
        return this.dateFormat.parse(string);
    }
}

