/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.MCONumber;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class AmadeusProductNumberProvider
extends BaseTargetsProvider<String> {
    public Collection<String> getTargets(MessageContext ctx) throws Exception {
        AirFile file = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        MCONumber mcoNumber = AmadeusParserHelper.getMCONumber(file);
        if (mcoNumber != null) {
            return Arrays.asList(mcoNumber.getTicketNumber());
        }
        ArrayList<String> ticketNumbers = new ArrayList<String>();
        for (TicketData ticket : file.getTickets()) {
            ticketNumbers.add(ticket.getTicketNumber());
        }
        return ticketNumbers;
    }
}

