/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketedAirSegment;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;

public class AmadeusUpdateAirFileForExchangeProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AirFile airFile = (AirFile)ctx.getObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        this.updateSegmentDates(airFile, product);
    }

    private void updateSegmentDates(AirFile airFile, Product secondSell) {
        Product previousProduct = secondSell.getPreviousProduct();
        if (previousProduct == null || previousProduct.getStatus() != ProductStatus.EXCHANGE) {
            return;
        }
        Product firstSell = previousProduct.getPreviousProduct();
        if (firstSell == null || firstSell.getStatus() != ProductStatus.SELL) {
            return;
        }
        if (secondSell.getIssueDate() == null || firstSell.getIssueDate() == null) {
            return;
        }
        for (TicketedAirSegment airSegment : airFile.getTicketedAirSegments()) {
            if (this.isNeedCorrectYear(secondSell, firstSell, airSegment.getDeparture())) {
                airSegment.setDeparture(MiscUtil.addYearsToDate((Date)airSegment.getDeparture(), (int)-1));
            }
            if (!this.isNeedCorrectYear(secondSell, firstSell, airSegment.getArrival())) continue;
            airSegment.setArrival(MiscUtil.addYearsToDate((Date)airSegment.getArrival(), (int)-1));
        }
    }

    private boolean isNeedCorrectYear(Product secondSell, Product firstSell, Date date) {
        if (date == null) {
            return false;
        }
        if (secondSell.getIssueDate().before(MiscUtil.addYearsToDate((Date)date, (int)-1))) {
            return false;
        }
        return !MiscUtil.addYearsToDate((Date)firstSell.getIssueDate(), (int)1).after(date);
    }
}

