/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class AmadeusUpdateBookingFromSellProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Product oldProduct = (Product)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.OLD_PRODUCT);
        Product newProduct = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        oldProduct.setStatus(ProductStatus.SELL);
        oldProduct.setCreatedByParser(true);
        oldProduct.setSystemNumber(newProduct.getSystemNumber());
        oldProduct.setIssueDate(newProduct.getIssueDate());
        oldProduct.setConjCount(newProduct.getConjCount());
        oldProduct.setPcc(newProduct.getPcc());
        oldProduct.setBlankOwnerNumber(newProduct.getBlankOwnerNumber());
        oldProduct.setBlankOwnerRef(newProduct.getBlankOwnerRef());
        oldProduct.setContractRulesApplied(false);
        if (oldProduct.getVendorVatDetalization() != null) {
            oldProduct.getVendorVatDetalization().setDetalized(false);
        }
        oldProduct.getSegmentTariffs().clear();
        oldProduct.getSegmentTariffs().addAll(newProduct.getSegmentTariffs());
        if (!AirProductHelper.getEquivalentFare((Product)oldProduct).equals(AirProductHelper.getEquivalentFare((Product)newProduct))) {
            oldProduct.getFares().clear();
            oldProduct.getFares().addAll(newProduct.getFares());
        }
        if (!AirProductTaxHelper.getEquivalentTaxesAmount((Product)oldProduct).equals(AirProductTaxHelper.getEquivalentTaxesAmount((Product)newProduct))) {
            oldProduct.getTaxes().clear();
            oldProduct.getTaxes().addAll(newProduct.getTaxes());
        }
        AirProductHelper.updateFops((Product)oldProduct);
        if (newProduct.getBspCommissionValue() != null) {
            oldProduct.setBspCommissionValue(newProduct.getBspCommissionValue());
        }
        if (newProduct.getBspCommissionRate() != null) {
            oldProduct.setBspCommissionRate(newProduct.getBspSubagentCommissionRate());
        }
        ctx.putObject((Enum)IBusParsersContextKeys.BOOKING_FILE_CHANGED, (Object)Boolean.TRUE);
    }
}

