/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.IBusProfileContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.model.FopItem;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.AdditionalServiceData;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.EMDSegment;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.MCONumber;
import com.gridnine.xtrip.common.parsers.model.amadeus.Tax;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.math.BigDecimal;
import java.util.ArrayList;

public class AmadeusUpdateContextForEmdProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        MCONumber mcoNumber;
        ctx.putObject((Enum)IBusParsersContextKeys.GDS_NAME, (Object)AmadeusParserHelper.getGdsName(ctx));
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        ctx.putObject((Enum)IBusProfileContextKeys.VALIDATOR, null);
        ctx.putObject((Enum)IBusProfileContextKeys.PCC, null);
        ctx.putObject((Enum)IBusProfileContextKeys.AGENT_CODE, null);
        ctx.putObject((Enum)IBusParsersContextKeys.ISSUE_DATE, null);
        ctx.putObject((Enum)IBusProfileContextKeys.AGENCY, null);
        ctx.putObject((Enum)IBusProfileContextKeys.AGENT, null);
        ctx.putObject((Enum)IBusProfileContextKeys.SALES_POINT, null);
        ctx.putObject((Enum)IBusProfileContextKeys.SUBAGENCY, null);
        ctx.putObject((Enum)IBusProfileContextKeys.SUPPLIER, null);
        ctx.putObject((Enum)IBusParsersContextKeys.EXCHANGE_FOPS_DATA, null);
        ctx.putObject((Enum)IBusParsersContextKeys.ETICKET_FLAG, (Object)Boolean.TRUE);
        ctx.putObject((Enum)IBusProfileContextKeys.VALIDATOR, (Object)airFile.getHeader().getTicketingAgencyIATANumber());
        ctx.putObject((Enum)IBusProfileContextKeys.PCC, (Object)airFile.getHeader().getTicketingAgencyOfficeID());
        ctx.putObject((Enum)IBusParsersContextKeys.BOOKING_PCC, (Object)airFile.getHeader().getCurrentOwnerOfficeID());
        ctx.putObject((Enum)IBusProfileContextKeys.AGENT_CODE, (Object)airFile.getServicingCarrier().getTicketingAgentSine());
        ctx.putObject((Enum)IBusParsersContextKeys.TICKET_NUMBER, (Object)AmadeusParserHelper.getEmdNumber(airFile));
        ctx.putObject((Enum)IBusParsersContextKeys.CONJUNCTIONS_COUNT, (Object)0);
        ctx.putObject((Enum)IBusParsersContextKeys.ISSUE_DATE, (Object)airFile.getPnrDate().getChangeDate());
        Product prod = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        String equiveCurrencyCode = AmadeusParserHelper.getGdsCurrency(airFile, AmadeusParserHelper.getGdsName(ctx));
        EMDSegment item = null;
        AdditionalServiceData asd = (AdditionalServiceData)ctx.getObject((Enum)IBusAmadeusParserContextKeys.ADDITIONAL_SERVICE_DATA);
        if (asd != null) {
            mcoNumber = asd.getMcoNumber();
            ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA, (Object)asd.getTicketData());
        } else {
            TicketData ticketData = (TicketData)ctx.getObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA);
            MCONumber mCONumber = mcoNumber = ticketData == null ? AmadeusParserHelper.getMCONumber(airFile) : (MCONumber)ticketData.getMcoNumbers().get(0);
        }
        if (mcoNumber != null) {
            item = airFile.getEmdSegments().stream().filter(it -> it.getTsmNumber() != null && it.getTsmNumber().equals(mcoNumber.getTsmNumber())).findFirst().orElse(null);
        }
        if (item != null) {
            boolean equivalentFareIsWrong;
            BigDecimal taxAmount = BigDecimal.ZERO;
            for (Tax fileTax : item.getTaxes()) {
                if (fileTax.getTaxAmount() == null) continue;
                com.gridnine.xtrip.common.model.booking.air.Tax tax = new com.gridnine.xtrip.common.model.booking.air.Tax();
                tax.setCode(fileTax.getTaxCode());
                tax.setEquivalentAmount(fileTax.getTaxAmount());
                prod.getTaxes().add(tax);
                taxAmount = taxAmount.add(fileTax.getTaxAmount());
            }
            Money equivalentAmount = item.getEquivalentAmount();
            boolean bl = equivalentFareIsWrong = equivalentAmount == null || equivalentAmount.getValue() == null || BigDecimal.ZERO.compareTo(equivalentAmount.getValue()) == 0 && item.getTotalBaseAmount() != null && item.getTotalBaseAmount().getValue() != null && BigDecimal.ZERO.compareTo(item.getTotalBaseAmount().getValue()) != 0;
            if (!equivalentFareIsWrong) {
                AirProductHelper.setEquivalentFare((Product)prod, (BigDecimal)equivalentAmount.getValue());
                ctx.putObject((Enum)IBusAmadeusParserContextKeys.TOTAL_TICKET_AMOUNT, (Object)MiscUtil.sum((BigDecimal[])new BigDecimal[]{taxAmount, equivalentAmount.getValue()}));
            } else if (item.getTotalBaseAmount() != null && item.getTotalBaseAmount().getCurrency() != null && item.getTotalBaseAmount().getValue() != null && item.getTotalBaseAmount().getCurrency().equals(equiveCurrencyCode)) {
                AirProductHelper.setEquivalentFare((Product)prod, (BigDecimal)item.getTotalBaseAmount().getValue());
                ctx.putObject((Enum)IBusAmadeusParserContextKeys.TOTAL_TICKET_AMOUNT, (Object)MiscUtil.sum((BigDecimal[])new BigDecimal[]{taxAmount, item.getTotalBaseAmount().getValue()}));
            }
            if (item.getTotalBaseAmount() != null) {
                AirProductHelper.setBaseFare((Product)prod, (Money)item.getTotalBaseAmount());
            } else {
                Money exceessBaggageRatePerUnit = item.getExceessBaggageRatePerUnit();
                if (exceessBaggageRatePerUnit != null && exceessBaggageRatePerUnit.getValue() != null) {
                    Money money = new Money();
                    money.setValue(exceessBaggageRatePerUnit.getValue().multiply(new BigDecimal(item.getExcessBaggageTotalNumber())));
                    money.setCurrency(exceessBaggageRatePerUnit.getCurrency());
                    AirProductHelper.setBaseFare((Product)prod, (Money)money);
                } else {
                    Money money = new Money();
                    money.setValue(AirProductHelper.getEquivalentFare((Product)prod));
                    money.setCurrency(equivalentAmount != null ? equivalentAmount.getCurrency() : equiveCurrencyCode);
                    AirProductHelper.setBaseFare((Product)prod, (Money)money);
                }
            }
        }
        if (airFile.getEmdPayment() == null || airFile.getEmdPayment().getFormOfPayment() == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0432 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0444\u043e\u0440\u043c\u0430\u0445 \u043e\u043f\u043b\u0430\u0442\u044b \u0434\u043b\u044f EMD {0}", (Object[])((Object[])ctx.getMandatoryObject((Enum)IBusParsersContextKeys.TICKET_NUMBER))));
            return;
        }
        BigDecimal totalTicketAmount = (BigDecimal)ctx.getObject((Enum)IBusAmadeusParserContextKeys.TOTAL_TICKET_AMOUNT);
        if (totalTicketAmount != null) {
            ArrayList<FopItem> fops = new ArrayList<FopItem>();
            FopItem fopItem = new FopItem();
            fopItem.setPaymentType(airFile.getEmdPayment().getFormOfPayment());
            fopItem.setAmount(totalTicketAmount);
            fops.add(fopItem);
            ctx.putObject((Enum)IBusParsersContextKeys.FOPS_DATA, fops);
        }
    }
}

