/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.IBusProfileContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.FopItem;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.math.BigDecimal;
import java.util.ArrayList;

public class AmadeusUpdateContextForInsuranceAccidentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ctx.putObject((Enum)IBusParsersContextKeys.GDS_NAME, (Object)AmadeusParserHelper.getGdsName(ctx));
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        ctx.putObject((Enum)IBusProfileContextKeys.VALIDATOR, null);
        ctx.putObject((Enum)IBusProfileContextKeys.PCC, null);
        ctx.putObject((Enum)IBusProfileContextKeys.AGENT_CODE, null);
        ctx.putObject((Enum)IBusParsersContextKeys.ISSUE_DATE, null);
        ctx.putObject((Enum)IBusProfileContextKeys.AGENCY, null);
        ctx.putObject((Enum)IBusProfileContextKeys.AGENT, null);
        ctx.putObject((Enum)IBusProfileContextKeys.SALES_POINT, null);
        ctx.putObject((Enum)IBusProfileContextKeys.SUBAGENCY, null);
        ctx.putObject((Enum)IBusProfileContextKeys.SUPPLIER, null);
        ctx.putObject((Enum)IBusParsersContextKeys.EXCHANGE_FOPS_DATA, null);
        ctx.putObject((Enum)IBusParsersContextKeys.ETICKET_FLAG, (Object)Boolean.TRUE);
        ctx.putObject((Enum)IBusProfileContextKeys.VALIDATOR, (Object)airFile.getHeader().getTicketingAgencyIATANumber());
        ctx.putObject((Enum)IBusProfileContextKeys.PCC, (Object)airFile.getHeader().getTicketingAgencyOfficeID());
        ctx.putObject((Enum)IBusParsersContextKeys.BOOKING_PCC, (Object)airFile.getHeader().getCurrentOwnerOfficeID());
        ctx.putObject((Enum)IBusProfileContextKeys.AGENT_CODE, (Object)airFile.getServicingCarrier().getTicketingAgentSine());
        ctx.putObject((Enum)IBusParsersContextKeys.TICKET_NUMBER, (Object)AmadeusParserHelper.getEmdNumber(airFile));
        ctx.putObject((Enum)IBusParsersContextKeys.CONJUNCTIONS_COUNT, (Object)0);
        ctx.putObject((Enum)IBusParsersContextKeys.ISSUE_DATE, (Object)airFile.getPnrDate().getChangeDate());
        if (airFile.getEmdPayment() == null || airFile.getEmdPayment().getFormOfPayment() == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0432 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0444\u043e\u0440\u043c\u0430\u0445 \u043e\u043f\u043b\u0430\u0442\u044b \u0434\u043b\u044f EMD {0}", (Object[])((Object[])ctx.getMandatoryObject((Enum)IBusParsersContextKeys.TICKET_NUMBER))));
            return;
        }
        BigDecimal totalTicketAmount = (BigDecimal)ctx.getObject((Enum)IBusAmadeusParserContextKeys.TOTAL_TICKET_AMOUNT);
        if (totalTicketAmount != null) {
            ArrayList<FopItem> fops = new ArrayList<FopItem>();
            FopItem fopItem = new FopItem();
            fopItem.setPaymentType(airFile.getEmdPayment().getFormOfPayment());
            fopItem.setAmount(totalTicketAmount);
            fops.add(fopItem);
            ctx.putObject((Enum)IBusParsersContextKeys.FOPS_DATA, fops);
        }
    }
}

