/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.FopItem;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AmadeusUpdateContextWithExchangeMcoFopDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PaymentType paymentType;
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        List exchangeFops = (List)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_FOPS_DATA);
        BigDecimal exchangedFopsSum = exchangeFops.stream().map(FopItem::getAmount).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(BigDecimal.ZERO);
        BigDecimal totalEquivalentFare = AirProductHelper.getTotalEquivalentFare((Product)product);
        BigDecimal difference = totalEquivalentFare.subtract(exchangedFopsSum);
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        PaymentType paymentType2 = paymentType = airFile.getEmdPayment() != null ? airFile.getEmdPayment().getFormOfPayment() : null;
        if (paymentType == null) {
            paymentType = PaymentType.CASH;
        }
        FopItem pi = new FopItem();
        pi.setPaymentType(paymentType);
        pi.setAmount(difference);
        ctx.putObject((Enum)IBusParsersContextKeys.FOPS_DATA, Collections.singletonList(pi));
    }
}

