/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.FopItem;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;

public class AmadeusUpdateContextWithFopDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        TicketData ticketData = (TicketData)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA);
        BigDecimal totalAmount = (BigDecimal)ctx.getObject((Enum)IBusAmadeusParserContextKeys.TOTAL_TICKET_AMOUNT);
        if (totalAmount == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0432 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u043e\u043b\u043d\u043e\u0439 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u0431\u0438\u043b\u0435\u0442\u0430 {0}", (Object[])new Object[]{ticketData.getTicketNumber()}));
            return;
        }
        ArrayList<PaymentType> paymentTypes = new ArrayList<PaymentType>();
        BaseProduct prod = (BaseProduct)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        if (ProductHandler.of((BaseProduct)prod).getProductCategory(prod) == ProductCategory.MCO || prod instanceof AeroexpressTicket) {
            AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
            paymentTypes.add(airFile.getEmdPayment().getFormOfPayment());
        } else {
            paymentTypes.addAll(ticketData.getPaymentTypes());
        }
        if (paymentTypes.isEmpty()) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0432 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0444\u043e\u0440\u043c\u0430\u0445 \u043e\u043f\u043b\u0430\u0442\u044b \u0434\u043b\u044f \u0431\u0438\u043b\u0435\u0442\u0430 {0}", (Object[])new Object[]{ticketData.getTicketNumber()}));
            return;
        }
        if (paymentTypes.size() > 2) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0432 \u0431\u0438\u043b\u0435\u0442\u0435 {0} \u0431\u043e\u043b\u0435\u0435 2 \u0444\u043e\u0440\u043c \u043e\u043f\u043b\u0430\u0442\u044b, \u0442\u0430\u043a\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", (Object[])new Object[]{ticketData.getTicketNumber()}));
            return;
        }
        if (paymentTypes.size() == 1) {
            FopItem fopItem = new FopItem();
            fopItem.setPaymentType((PaymentType)paymentTypes.get(0));
            fopItem.setAmount(totalAmount);
            if (PaymentType.MTD.equals(paymentTypes.get(0))) {
                fopItem.setPassengerStatus(ticketData.getPassengerStatus());
                fopItem.setDetails(ticketData.getDocumentNumber());
            }
            ctx.putObject((Enum)IBusParsersContextKeys.FOPS_DATA, Collections.singletonList(fopItem));
            return;
        }
        if (ticketData.getCreditCardAmount() == null || ticketData.getCreditCardAmount().getValue() == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0432 \u0431\u0438\u043b\u0435\u0442\u0435 {0} 2 \u0444\u043e\u0440\u043c\u044b \u043e\u043f\u043b\u0430\u0442\u044b, \u043d\u043e \u043d\u0435\u0442 \u0441\u0443\u043c\u043c\u044b \u043f\u043e \u0432\u0442\u043e\u0440\u043e\u0439 \u0444\u043e\u0440\u043c\u0435 \u043e\u043f\u043b\u0430\u0442\u044b", (Object[])new Object[]{ticketData.getTicketNumber()}));
            return;
        }
        if (ticketData.getCreditCardAmount() == null || ticketData.getCreditCardAmount().getValue() == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0432 \u0431\u0438\u043b\u0435\u0442\u0435 {0} 2 \u0444\u043e\u0440\u043c\u044b \u043e\u043f\u043b\u0430\u0442\u044b, \u043d\u043e \u043d\u0435\u0442 \u0441\u0443\u043c\u043c\u044b \u043f\u043e \u0432\u0442\u043e\u0440\u043e\u0439 \u0444\u043e\u0440\u043c\u0435 \u043e\u043f\u043b\u0430\u0442\u044b", (Object[])new Object[]{ticketData.getTicketNumber()}));
            return;
        }
        LinkedList<FopItem> fops = new LinkedList<FopItem>();
        FopItem fopItem = new FopItem();
        fopItem.setPaymentType((PaymentType)paymentTypes.get(1));
        fopItem.setAmount(ticketData.getCreditCardAmount().getValue());
        if (PaymentType.MTD.equals(paymentTypes.get(1))) {
            fopItem.setPassengerStatus(ticketData.getPassengerStatus());
            fopItem.setDetails(ticketData.getDocumentNumber());
        }
        fops.add(fopItem);
        fopItem = new FopItem();
        fopItem.setPaymentType((PaymentType)paymentTypes.get(0));
        fopItem.setAmount(totalAmount.subtract(ticketData.getCreditCardAmount().getValue()));
        if (PaymentType.MTD.equals(paymentTypes.get(0))) {
            fopItem.setPassengerStatus(ticketData.getPassengerStatus());
            fopItem.setDetails(ticketData.getDocumentNumber());
        }
        fops.addFirst(fopItem);
        ctx.putObject((Enum)IBusParsersContextKeys.FOPS_DATA, fops);
    }
}

