/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.amadeus.AdditionalServiceData;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.MCONumber;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.util.Map;

public class AmadeusUpdateEmdHeaderProcessor
extends BaseProcessor {
    private MCOCategory mcoCategory;

    public void configure(Map<String, String> parameters) {
        this.mcoCategory = MCOCategory.valueOf((String)parameters.get("mcoCategory"));
    }

    public void process(MessageContext ctx) throws Exception {
        TicketData ticketData;
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        product.setProductCategory(ProductCategory.MCO);
        if (product.getMcoCategory() == null) {
            product.setMcoCategory(this.mcoCategory);
        }
        product.setPcc(airFile.getHeader().getTicketingAgencyOfficeID());
        AdditionalServiceData asd = (AdditionalServiceData)ctx.getObject((Enum)IBusAmadeusParserContextKeys.ADDITIONAL_SERVICE_DATA);
        MCONumber mcoNumber = asd != null ? asd.getMcoNumber() : ((ticketData = (TicketData)ctx.getObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA)) == null ? AmadeusParserHelper.getMCONumber(airFile) : (MCONumber)ticketData.getMcoNumbers().get(0));
        product.setGdsCurrency(AmadeusParserHelper.getGdsCurrency(airFile, AmadeusParserHelper.getGdsName(ctx)));
        String validatingAirlineNumber = mcoNumber == null ? null : Integer.toString(mcoNumber.getNumericAirlineCode());
        product.setCarrierNumber(validatingAirlineNumber);
        Airline airline = DictHelper.findAirlineByAnyCode((String)validatingAirlineNumber);
        if (airline != null) {
            product.setCarrier((DictionaryReference)airline.toReference());
            if (product.getCarrierNumber() == null) {
                product.setCarrierNumber(airline.getAirlineNumber());
            }
        } else {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u0430\u043b\u0438\u0434\u0438\u0440\u0443\u044e\u0449\u0443\u044e \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044e \u043f\u043e \u043a\u043e\u0434\u0443 {1}", (Object[])new Object[]{mcoNumber.getTicketNumber(), validatingAirlineNumber}));
        }
        product.setFareCalculationData(airFile.getFare().getCalculation());
    }
}

