/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.FopItem;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.util.Collections;

public class AmadeusUpdateExchangedMcoProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        AmadeusParserHelper.correctStandardExchangeFields(product.getPreviousProduct(), ctx);
        for (Object item : AirProductHelper.getContractRelations((Product)product.getPreviousProduct())) {
            if (GeneralProductHelper.getContractType((EntityReference)item.getDescription()) == ContractType.VENDOR) continue;
            item.getFops().clear();
        }
        PaymentType pt = null;
        for (ProductFop item : AirProductHelper.getVendorContractRelation((Product)product.getPreviousProduct()).getFops()) {
            if (item.getAmount() == null || item.getAmount().getValue() == null || item.getType() == PaymentType.TICKET || item.getType() == null) continue;
            pt = item.getType();
        }
        FopItem pi = new FopItem();
        pi.setPaymentType(pt == null ? PaymentType.CASH : pt);
        pi.setAmount(HandlersRegistry.get().findProductHandler(Product.class).calculateProductPrice((BaseProduct)product.getPreviousProduct(), ContractType.VENDOR).getTotal().negate());
        ctx.putObject((Enum)IBusParsersContextKeys.EXCHANGE_FOPS_DATA, Collections.singletonList(pi));
    }
}

