/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.IBusProfileContextKeys;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.FopItem;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.Tax;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class AmadeusUpdateExchangedProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BigDecimal vouchersAmount;
        EntityContainer blankOwnerCtr;
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        TicketData ticketData = (TicketData)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        EntityReference blankOwner = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.BLANK_OWNER);
        AmadeusParserHelper.correctStandardExchangeFields(product.getPreviousProduct(), ctx);
        for (AirProductContractRelationData item : AirProductHelper.getContractRelations((Product)product.getPreviousProduct())) {
            if (GeneralProductHelper.getContractType((EntityReference)item.getDescription()) == ContractType.VENDOR) continue;
            item.getFops().clear();
        }
        boolean smartTickettingMode = false;
        if (blankOwner != null && (blankOwnerCtr = EntityStorage.get().resolve(blankOwner)) != null && "S7".equals(DictHelper.getCodeVariant((DictionaryReference)((Organization)blankOwnerCtr.getEntity()).getAirline(), (CodeSystem[])new CodeSystem[]{CodeSystem.IATA}))) {
            smartTickettingMode = true;
        }
        ctx.putObject((Enum)IBusAmadeusParserContextKeys.S7_SMART_TICKETTING_MODE, (Object)smartTickettingMode);
        if (!smartTickettingMode) {
            this.correctReturnedTaxes(airFile, ticketData, product.getPreviousProduct(), ctx);
        }
        this.correctExchangeFops(product.getPreviousProduct(), ctx);
        BigDecimal totalAmount = BigDecimal.ZERO;
        PaymentType pt = null;
        for (ProductFop item : AirProductHelper.getVendorContractRelation((Product)product.getPreviousProduct()).getFops()) {
            if (item.getAmount() == null || item.getAmount().getValue() == null || item.getType() == PaymentType.TICKET || item.getType() == null) continue;
            pt = item.getType();
        }
        FopItem pi = new FopItem();
        pi.setPaymentType(pt == null ? PaymentType.CASH : pt);
        pi.setAmount(HandlersRegistry.get().findProductHandler(Product.class).calculateProductPrice(null, (BaseProduct)product.getPreviousProduct()).getTotal().negate());
        totalAmount = totalAmount.add(pi.getAmount());
        ctx.putObject((Enum)IBusParsersContextKeys.EXCHANGE_FOPS_DATA, Collections.singletonList(pi));
        BigDecimal addAmmount = airFile.getFare().getTotalAmount();
        if (addAmmount != null && addAmmount.compareTo(BigDecimal.ZERO) > 0) {
            totalAmount = totalAmount.add(addAmmount);
        }
        if ((vouchersAmount = this.getVouchersAmount(airFile, ticketData)).compareTo(BigDecimal.ZERO) > 0) {
            totalAmount = totalAmount.subtract(vouchersAmount);
        }
        ctx.putObject((Enum)IBusAmadeusParserContextKeys.TOTAL_TICKET_AMOUNT, (Object)totalAmount);
        for (Tax tax : new ArrayList(airFile.getFare().getAllTaxes())) {
            if (!"CP".equals(tax.getTaxCode())) continue;
            if (!"O".equals(tax.getTaxIndicator())) {
                product.setPenalty(tax.getTaxAmount());
            }
            airFile.getFare().getAllTaxes().remove(tax);
        }
    }

    private void correctExchangeFops(Product exchange, MessageContext ctx) {
        BigDecimal fopsAmount;
        BigDecimal totalExchange = MiscUtil.sum((BigDecimal[])new BigDecimal[]{AirProductHelper.getEquivalentFare((Product)exchange), AirProductTaxHelper.getEquivalentTaxesAmount((Product)exchange)});
        if (!MiscUtil.equals((Object)totalExchange, (Object)(fopsAmount = AirProductHelper.getVendorFops((Product)exchange).stream().filter(f -> AirProductHelper.isServiceFop((ProductFop)f) && f.getAmount() != null && f.getAmount().getValue() != null).map(f -> f.getAmount().getValue()).reduce(BigDecimal.ZERO, (a, b) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{a, b}))))) {
            AirProductHelper.updateFops((Product)exchange);
        }
    }

    private boolean correctReturnedTaxes(AirFile airFile, TicketData ticketData, Product exchange, MessageContext ctx) {
        List taxes = ticketData.getFare() != null && !ticketData.getFare().getFormattedTaxes().isEmpty() ? ticketData.getFare().getFormattedTaxes() : airFile.getFare().getFormattedTaxes();
        BigDecimal taxAmount = AirProductTaxHelper.getEquivalentTaxesAmount((Product)exchange);
        BigDecimal sum = BigDecimal.ZERO;
        boolean hasXTTax = false;
        for (Tax tax : taxes) {
            if ("CP".equals(tax.getTaxCode())) continue;
            boolean bl = hasXTTax = hasXTTax || "XT".equals(tax.getTaxCode());
            if (tax.getTaxAmount() == null) continue;
            sum = sum.add(tax.getTaxAmount());
        }
        if (sum.compareTo(taxAmount) == 0) {
            return false;
        }
        if (hasXTTax) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043f\u0440\u0438 \u043e\u0431\u043c\u0435\u043d\u0435 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0438 \u043d\u0435\u0443\u0447\u0442\u0435\u043d\u043d\u044b\u0435 \u0442\u0430\u043a\u0441\u044b", (Object[])new Object[0]));
            return false;
        }
        boolean changed = false;
        Iterator it = exchange.getTaxes().iterator();
        while (it.hasNext()) {
            com.gridnine.xtrip.common.model.booking.air.Tax tax = (com.gridnine.xtrip.common.model.booking.air.Tax)it.next();
            boolean found = false;
            for (Tax rt : taxes) {
                if ("CP".equals(rt.getTaxCode()) || !"PD".equals(rt.getCurrency()) || rt.getTaxCode() == null || !rt.getTaxCode().equals(tax.getCode())) continue;
                found = true;
                break;
            }
            if (found || taxes.isEmpty()) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    private BigDecimal getVouchersAmount(AirFile file, TicketData ticketData) {
        return ticketData.getMcoNumbers().stream().map(mcoNumber -> AmadeusParserHelper.getVoucherAmount(file, mcoNumber)).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(BigDecimal.ZERO);
    }
}

