/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.IBusProfileContextKeys;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.EMDSegment;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;

public class AmadeusUpdateInsuranceAccidentSpecificFieldsProcessor
extends BaseProcessor {
    private static final String blankTypeAbsent = "\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0431\u043b\u0430\u043d\u043a\u0430 \u0434\u043b\u044f {0} \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443 {1}";
    private static final String blankTypeNoEticket = "\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0431\u043b\u0430\u043d\u043a\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u0434\u043b\u044f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 {0} \u043d\u0435\u0442 \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0431\u043b\u0430\u043d\u043a\u0430 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 {1}";
    private static final String blankTypeNoBlankOwner = "\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0431\u043b\u0430\u043d\u043a\u0430, \u043f\u043e\u0442\u043e\u043c\u0443 \u0447\u0442\u043e \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0431\u043b\u0430\u043d\u043a\u043e\u0432";

    public void process(MessageContext ctx) throws Exception {
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        Boolean eticketFlag = (Boolean)ctx.getObject((Enum)IBusParsersContextKeys.ETICKET_FLAG);
        InsuranceAccident product = (InsuranceAccident)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        String ticketNumber = (String)ctx.getObject((Enum)IBusParsersContextKeys.TICKET_NUMBER);
        GdsName gdsName = (GdsName)ctx.getObject((Enum)IBusParsersContextKeys.GDS_NAME);
        String pnr = (String)ctx.getObject((Enum)IBusParsersContextKeys.PNR);
        if (product.getSystemNumber() == null) {
            product.setSystemNumber(ticketNumber);
        }
        EntityReference agency = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.AGENCY);
        InsuranceAccidentHelper.setAgency((InsuranceAccident)product, (EntityReference)agency);
        if (product.getReservation().getBookingFile().getAgency() == null) {
            product.getReservation().getBookingFile().setAgency(agency);
        }
        EntityReference blankOwner = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.BLANK_OWNER);
        product.setBlankOwner(blankOwner);
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)product.getReservation(), (GdsName)gdsName, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)pnr);
        product.setBlankType(this.findBlankType(ticketNumber, (EntityReference<Organization>)blankOwner, ProductCategory.MCO, eticketFlag, ctx));
        EntityReference agent = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.AGENT);
        product.setAgent(agent);
        product.setIssueDate((Date)ctx.getObject((Enum)IBusParsersContextKeys.ISSUE_DATE));
        if (product.getPassengerType() == null) {
            product.setPassengerType(DictHelper.getAdultPassengerType());
        }
        EntityReference salesPoint = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.SALES_POINT);
        product.setSalesPoint(salesPoint);
        EntityReference subagency = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.SUBAGENCY);
        InsuranceAccidentHelper.setSubagency((InsuranceAccident)product, (EntityReference)subagency);
        EntityReference supplier = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.SUPPLIER);
        InsuranceAccidentHelper.setSupplier((InsuranceAccident)product, (EntityReference)supplier);
        String pcc = (String)ctx.getObject((Enum)IBusProfileContextKeys.PCC);
        product.setPcc(pcc);
        String bookingPcc = (String)ctx.getObject((Enum)IBusParsersContextKeys.BOOKING_PCC);
        if (TextUtil.nonBlank((String)bookingPcc)) {
            CommonReservationGdsNameInfoHelper.setBookingPcc((Reservation)product.getReservation(), (GdsName)gdsName, (String)bookingPcc);
        }
        if (!airFile.getEmdSegments().isEmpty()) {
            EMDSegment emdSegment = (EMDSegment)airFile.getEmdSegments().get(0);
            Money equivalentAmount = emdSegment.getEquivalentAmount();
            product.setEquivalentSum(equivalentAmount.getValue());
            ctx.putObject((Enum)IBusAmadeusParserContextKeys.TOTAL_TICKET_AMOUNT, (Object)equivalentAmount.getValue());
        }
    }

    private DictionaryReference<BlankType> findBlankType(String ticketNumber, EntityReference<Organization> blankOwner, ProductCategory category, Boolean eticketFlag, MessageContext ctx) {
        if (blankOwner == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)blankTypeNoBlankOwner, (Object[])new Object[0]));
            return null;
        }
        if (Boolean.TRUE.equals(eticketFlag)) {
            for (BlankType item : BookingHelper.getBlankTypesByVendor(blankOwner)) {
                if (item.getBlankCategory() != BlankCategory.ETICKET || item.getProductCategory() != category) continue;
                return item.toReference();
            }
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)blankTypeNoEticket, (Object[])new Object[]{blankOwner, category}));
            return null;
        }
        for (BlankType item : BookingHelper.getBlankTypesByVendor(blankOwner)) {
            if (item.getName() == null || !ticketNumber.startsWith(item.getName())) continue;
            return item.toReference();
        }
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)blankTypeAbsent, (Object[])new Object[]{blankOwner, ticketNumber}));
        return null;
    }
}

