/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;

public class AmadeusUpdateProductHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        TicketData ticketData = (TicketData)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA);
        product.setProductCategory(ProductCategory.AIR);
        product.setPcc(airFile.getHeader().getTicketingAgencyOfficeID());
        product.setGdsCurrency(AmadeusParserHelper.getGdsCurrency(airFile, AmadeusParserHelper.getGdsName(ctx)));
        String validatingAirlineNumber = ticketData.getValidatingAirlineNumber();
        if (TextUtil.isBlank((String)validatingAirlineNumber)) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 {0} \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u0434 \u0432\u0430\u043b\u0438\u0434\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438, \u0431\u0443\u0434\u0435\u043c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043a\u043e\u0434 \u0434\u043b\u044f \u0432\u0441\u0435\u0439 \u0431\u0440\u043e\u043d\u0438 {1}", (Object[])new Object[]{ticketData.getTicketNumber(), airFile.getValidatingCarrier().getAirlineCode()}));
            validatingAirlineNumber = airFile.getValidatingCarrier().getAirlineCode();
        } else {
            product.setCarrierNumber(validatingAirlineNumber);
        }
        Airline airline = DictHelper.findAirlineByAnyCode((String)validatingAirlineNumber);
        if (airline != null) {
            product.setCarrier((DictionaryReference)airline.toReference());
            if (product.getCarrierNumber() == null) {
                product.setCarrierNumber(airline.getAirlineNumber());
            }
        } else {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u0430\u043b\u0438\u0434\u0438\u0440\u0443\u044e\u0449\u0443\u044e \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044e \u043f\u043e \u043a\u043e\u0434\u0443 {1}", (Object[])new Object[]{ticketData.getTicketNumber(), airFile.getValidatingCarrier().getAirlineCode()}));
        }
        product.setEndorsement(ticketData.getEndorsement());
        product.setFareCalculationData(airFile.getFare().getCalculation());
        product.getTripartiteContractDetails().setContractCode(airFile.getTripartiteContractDetails().getContractCode());
        product.getTripartiteContractDetails().setContract(airFile.getTripartiteContractDetails().getContract());
    }
}

