/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.IBusProfileContextKeys;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.model.FopItem;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.Refund;
import com.gridnine.xtrip.common.parsers.model.amadeus.Tax;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AmadeusUpdateRefundProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Refund refund;
        BigDecimal newFare;
        Product result = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        TicketData ticketData = (TicketData)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.TICKET_DATA);
        List airFileFops = (List)ctx.getObject((Enum)IBusParsersContextKeys.FOPS_DATA);
        result.setIssueDate(airFile.getRefund().getRefundDate());
        BigDecimal oldFare = this.getFare(result.getPreviousProduct());
        BigDecimal bigDecimal = newFare = airFile.getRefund().getFareRefund() == null || airFile.getRefund().getFareRefund().getValue() == null ? BigDecimal.ZERO : airFile.getRefund().getFareRefund().getValue();
        if (newFare.compareTo(oldFare) != 0) {
            boolean hasUnlinkedFare = false;
            BigDecimal subtotal = BigDecimal.ZERO;
            BigDecimal usedFare = oldFare.subtract(newFare);
            ArrayList<SegmentTariff> toDelete = new ArrayList<SegmentTariff>();
            for (SegmentTariff item : result.getSegmentTariffs()) {
                BigDecimal ef = AirProductHelper.getSegmentEquivalentFare((Product)result, (SegmentTariff)item);
                if (ef == null) {
                    hasUnlinkedFare = true;
                    break;
                }
                if ((subtotal = subtotal.add(ef)).compareTo(usedFare) > 0) continue;
                toDelete.add(item);
            }
            if (!hasUnlinkedFare) {
                result.getSegmentTariffs().removeAll(toDelete);
            } else if (result.getSegmentTariffs().size() == 2) {
                result.getSegmentTariffs().remove(result.getSegmentTariffs().get(0));
            }
            result.getFares().clear();
            AirProductHelper.setEquivalentFare((Product)result, (BigDecimal)newFare);
            AirProductHelper.setBaseFare((Product)result, (Money)airFile.getRefund().getFareRefund());
        }
        if (airFile.getFare() != null) {
            result.getTaxes().clear();
            for (Tax item : airFile.getFare().getRefundableTaxes()) {
                com.gridnine.xtrip.common.model.booking.air.Tax tax = new com.gridnine.xtrip.common.model.booking.air.Tax();
                tax.setCode(item.getTaxCode());
                tax.setEquivalentAmount(item.getTaxAmount());
                result.getTaxes().add(tax);
            }
        }
        if ((refund = airFile.getRefund()).getCancellationFee() != null) {
            result.setPenalty(refund.getCancellationFee().getValue());
        }
        String agentCode = (String)ctx.getObject((Enum)IBusProfileContextKeys.AGENT_CODE);
        result.setCashierCode(agentCode);
        EntityReference agent = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.AGENT);
        result.setCashier(agent);
        EntityReference salesPoint = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.SALES_POINT);
        result.setSalesPoint(salesPoint);
        EntityReference subagency = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.SUBAGENCY);
        AirProductHelper.setSubagency((Product)result, (EntityReference)subagency);
        AirProductHelper.setSubagency((Product)result, (EntityReference)AirProductHelper.getSubagency((Product)result.getPreviousProduct()));
        result.setSalesPoint(result.getPreviousProduct().getSalesPoint());
        result.setStatus(ProductStatus.REFUND);
        AirProductHelper.updateFops((Product)result);
        if (airFileFops != null && airFileFops.size() == 1) {
            List productFops = AirProductHelper.getContractRelations((Product)result).stream().flatMap(data -> data.getFops().stream()).collect(Collectors.toList());
            for (ProductFop fop : productFops) {
                fop.setType(((FopItem)airFileFops.get(0)).getPaymentType());
            }
        }
        if (AirProductHelper.isBSPTicket((Product)result)) {
            Double bspCommissionRate = null;
            BigDecimal bspCommissionValue = null;
            if (ticketData.getCommissionRate() != null) {
                bspCommissionRate = ticketData.getCommissionRate();
                BigDecimal equivalentFare = AirProductHelper.getEquivalentFare((Product)result);
                if (equivalentFare != null) {
                    bspCommissionValue = equivalentFare.multiply(BigDecimal.valueOf(ticketData.getCommissionRate())).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
                }
            } else if (ticketData.getCommissionValue() != null) {
                bspCommissionValue = ticketData.getCommissionValue();
            }
            if (bspCommissionRate != null) {
                result.setBspCommissionRate(bspCommissionRate);
            }
            if (bspCommissionValue != null) {
                String equivalentCurrency = result.getGdsCurrency();
                result.setBspCommissionValue(MoneyHelper.buildMoney((BigDecimal)bspCommissionValue, (String)equivalentCurrency));
            }
        }
    }

    private BigDecimal getFare(Product prod) {
        BigDecimal res = AirProductHelper.getEquivalentFare((Product)prod);
        return res == null ? BigDecimal.ZERO : res;
    }
}

