/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.helpers.ValidatorHelper;
import com.gridnine.xtrip.common.model.profile.IBusProfileContextKeys;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.MCONumber;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class AmadeusVoidTicketProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String validator;
        String productNumber = (String)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.PRODUCT_NUMBER);
        AirFile file = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.RESERVATION);
        if (TextUtil.isBlank((String)productNumber)) {
            throw Xeption.forEndUser((String)"\u0432 \u0444\u0430\u0439\u043b\u0435 {0} \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u043e\u043c\u0435\u0440 \u0431\u0438\u043b\u0435\u0442\u0430", (Object[])new Object[]{ctx.getObject((Enum)IBusParsersContextKeys.FILE_LOCATION)});
        }
        EntityContainer ctr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        BookingFile bookingFile = (BookingFile)ctr.getEntity();
        List products = bookingFile.getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(bp -> bp instanceof Product).map(bp -> (Product)bp).collect(Collectors.toList());
        for (Product prod : products) {
            String validator2;
            EntityReference supplier;
            if (prod.getStatus() == ProductStatus.VOID && this.hasAppropritedSystemNumber(prod.getSystemNumber(), prod.getConjCount(), productNumber)) {
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0431\u0438\u043b\u0435\u0442 {0} \u0443\u0436\u0435 \u0432\u043e\u0439\u0434\u0438\u0440\u043e\u0432\u0430\u043d", (Object[])new Object[]{prod.getSystemNumber()}));
                ctx.putObject((Enum)IBusAmadeusParserContextKeys.PRODUCT_CHANGED, (Object)Boolean.FALSE);
                return;
            }
            if (prod.getStatus() != ProductStatus.SELL || !this.hasAppropritedSystemNumber(prod.getSystemNumber(), prod.getConjCount(), productNumber)) continue;
            if (this.productVoidImpossible(prod)) {
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"AmadeusParser_VoidImpossibleProductHasRelatedShipment", (Object[])new Object[]{prod.getSystemNumber()}));
                ctx.putObject((Enum)IBusAmadeusParserContextKeys.PRODUCT_CHANGED, (Object)Boolean.FALSE);
                return;
            }
            prod.setStatus(ProductStatus.VOID);
            if (prod.getIssueDate() == null) {
                prod.setIssueDate(file.getHeader().getVoidDate());
            }
            if ((supplier = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.SUPPLIER)) != null) {
                AirProductHelper.setSupplier((Product)prod, (EntityReference)supplier);
            }
            if (!TextUtil.isBlank((String)(validator2 = (String)ctx.getObject((Enum)IBusProfileContextKeys.VALIDATOR)))) {
                prod.setValidatorCode(validator2);
                AmadeusVoidTicketProcessor.setValidatorRef(prod, validator2);
            }
            if (prod.getPreviousProduct() != null && prod.getPreviousProduct().getStatus().equals((Object)ProductStatus.EXCHANGE)) {
                prod.getPreviousProduct().getPreviousProduct().setNextProduct(null);
                prod.getReservation().getProducts().remove(prod.getPreviousProduct());
                prod.setPreviousProduct(null);
            }
            ctx.putObject((Enum)IBusAmadeusParserContextKeys.PRODUCT_CHANGED, (Object)Boolean.TRUE);
            return;
        }
        Product prod = new Product();
        prod.setStatus(ProductStatus.VOID);
        prod.setCreatedByParser(true);
        prod.setTicketType(TicketType.FAKE);
        prod.setIssueDate(file.getHeader().getVoidDate());
        EntityReference supplier = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.SUPPLIER);
        if (supplier != null) {
            AirProductHelper.setSupplier((Product)prod, (EntityReference)supplier);
        }
        if (!TextUtil.isBlank((String)(validator = (String)ctx.getObject((Enum)IBusProfileContextKeys.VALIDATOR)))) {
            prod.setValidatorCode(validator);
        }
        String relatedTicketNumber = null;
        String carrierNumber = null;
        MCONumber mcoNumber = AmadeusParserHelper.getMCONumber(file);
        if (mcoNumber != null) {
            relatedTicketNumber = mcoNumber.getTicketNumber();
            carrierNumber = String.valueOf(mcoNumber.getNumericAirlineCode());
            prod.setProductCategory(ProductCategory.MCO);
        } else {
            relatedTicketNumber = ((TicketData)file.getTickets().get(0)).getTicketNumber();
            carrierNumber = ((TicketData)file.getTickets().get(0)).getValidatingAirlineNumber();
            prod.setProductCategory(ProductCategory.AIR);
        }
        prod.setSystemNumber(relatedTicketNumber);
        prod.setCarrierNumber(carrierNumber);
        Airline carrier = DictHelper.findAirlineByAnyCode((String)carrierNumber, (Date)file.getPnrDate().getCreationDate());
        if (carrier != null) {
            prod.setCarrier((DictionaryReference)carrier.toReference());
        }
        prod.setReservation(reservation);
        AmadeusVoidTicketProcessor.setValidatorRef(prod, validator);
        reservation.getProducts().add(prod);
        ctx.putObject((Enum)IBusAmadeusParserContextKeys.PRODUCT_CHANGED, (Object)Boolean.TRUE);
    }

    private static void setValidatorRef(Product product, String code) {
        if (TextUtil.isBlank((String)code)) {
            return;
        }
        ValidatorIndex validatorIndex = ValidatorHelper.getValidatorIndex((String)code, (EntityReference)product.getBlankOwnerRef(), (String)product.getPcc(), (Date)product.getIssueDate());
        if (validatorIndex != null) {
            product.setValidatorRef(new NestedEntityReference(validatorIndex.getSource(), validatorIndex.getNavigationKey(), Validator.class, null));
        }
    }

    private boolean hasAppropritedSystemNumber(String systemNumber, int conjCount, String ticketNumber) {
        if (TextUtil.isBlank((String)systemNumber)) {
            return false;
        }
        if (ticketNumber.equals(systemNumber)) {
            return true;
        }
        for (int n = 1; n <= conjCount; ++n) {
            if (!FormattedNumberUtil.add((String)systemNumber, (long)1L).equals(systemNumber)) continue;
            return true;
        }
        return false;
    }

    private boolean productVoidImpossible(Product product) {
        return ShipmentHelper.hasRelatedShipment((BaseProduct)product);
    }
}

