/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.registration;

import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.PCCIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.IgnoreExchangeDocumentException;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.util.Date;

public class AmadeusCheckExternalPCCProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        String sourcePCC = airFile.getHeader().getTicketingAgencyOfficeID();
        Date now = new Date();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ieq((String)PCCIndex.Property.code.name(), (String)sourcePCC));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PCCIndex.Property.gdsName.name(), (Object)AmadeusParserHelper.getGdsName(ctx)));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)PCCIndex.Property.opened.name(), null), SearchCriterion.le((String)PCCIndex.Property.opened.name(), (Object)now)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)PCCIndex.Property.closed.name(), null), SearchCriterion.ge((String)PCCIndex.Property.closed.name(), (Object)MiscUtil.clearTime((Date)now))}));
        query.setResultMode(ResultMode.COUNT_ONLY);
        SearchResult result = EntityStorage.get().search(PCCIndex.class, query);
        if (result.getTotalCount() == 0) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"file \"{0}\" has external pcc \"{1}\" and will be ignored", (Object[])new Object[]{(String)ctx.getObject((Enum)IBusParsersContextKeys.FILE_LOCATION), sourcePCC}));
            throw new IgnoreExchangeDocumentException("external-pcc");
        }
    }
}

