/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.registration;

import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.parsers.model.amadeus.AirFile;
import com.gridnine.xtrip.common.parsers.model.amadeus.AmadeusExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.amadeus.EMDSegment;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.parsers.model.amadeus.MCONumber;
import com.gridnine.xtrip.common.parsers.model.amadeus.TicketData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.common.AmadeusParserHelper;
import java.util.Collections;
import java.util.HashSet;

public class AmadeusCreateRegisteredDocumentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AirFile airFile = (AirFile)ctx.getMandatoryObject((Enum)IBusAmadeusParserContextKeys.AIR_FILE);
        AmadeusExchangeDocument doc = new AmadeusExchangeDocument();
        doc.setCreated(airFile.getCreated() == null ? null : airFile.getCreated().toDate());
        doc.setPNR(airFile.getHeader().getPnrRecordLocator());
        if (airFile.getHeader().isVoided()) {
            doc.setOperationDate(airFile.getHeader().getVoidDate());
        } else {
            doc.setOperationDate(airFile.getPnrDate().getChangeDate());
        }
        if (!airFile.getEmdSegments().isEmpty()) {
            if (AmadeusParserHelper.hasMainSell(airFile)) {
                if (!TextUtil.isBlank((String)airFile.getOriginalIssueTicketNumber())) {
                    doc.setTransactionType(TransactionType.EXCHANGE);
                } else {
                    doc.setTransactionType(TransactionType.SELL);
                }
            } else {
                EMDSegment emdSegment = (EMDSegment)airFile.getEmdSegments().get(0);
                if (!TextUtil.isBlank((String)emdSegment.getReasonDescription()) && (emdSegment.getReasonDescription().contains("CANCELLATION FEE") || emdSegment.getReasonDescription().contains("PENALTY FEE"))) {
                    doc.setTransactionType(TransactionType.MCO_PENALTY);
                } else if (emdSegment.getReasonDescription() != null && (emdSegment.getReasonDescription().contains("PRE RESERVED SEAT") || emdSegment.getReasonSubCodeDescription() != null && emdSegment.getReasonSubCodeDescription().contains("MY SEAT"))) {
                    doc.setTransactionType(TransactionType.SEAT_RESERVATION);
                } else if (emdSegment.getReasonDescription() != null && emdSegment.getReasonDescription().contains("DEPOSITS DOWN PAYMENTS") || emdSegment.getReasonSubCodeDescription() != null && emdSegment.getReasonSubCodeDescription().contains("GROUP DEPOSITS/DOWNPAYMENTS")) {
                    doc.setTransactionType(TransactionType.GROUP_PREPAYMENT);
                } else if (!TextUtil.isBlank((String)emdSegment.getExcessBaggageTotalNumber())) {
                    doc.setTransactionType(TransactionType.EXCESS_BAGGAGE);
                } else {
                    doc.setTransactionType(TransactionType.MCO_PENALTY);
                }
            }
        } else if (airFile.getRefund() != null) {
            doc.setTransactionType(TransactionType.REFUND);
        } else if (airFile.getHeader().isVoided()) {
            doc.setTransactionType(TransactionType.CANCEL);
        } else {
            TransactionType type = null;
            if (!TextUtil.isBlank((String)airFile.getOriginalIssueTicketNumber())) {
                type = TransactionType.EXCHANGE;
            }
            doc.setTransactionType(type != null ? type : TransactionType.SELL);
        }
        doc.setContentType(ContentType.TEXT);
        if (!airFile.getHeader().isVoided() && airFile.getRefund() == null && airFile.getEmdSegments().isEmpty() && airFile.getTicketedAirSegments().isEmpty()) {
            doc.setStatus(ProcessingStatus.ERROR);
            doc.setUnsupportedOperation(true);
        }
        HashSet<String> travellersNames = new HashSet<String>();
        for (Object ticketData : airFile.getTickets()) {
            String name;
            if (ticketData.getPassenger() == null || TextUtil.isBlank((String)(name = ticketData.getPassenger().getName()))) continue;
            travellersNames.add(name);
        }
        doc.getTravellerNames().addAll(travellersNames);
        HashSet<String> ticketNumbers = new HashSet<String>();
        for (TicketData ticketData : airFile.getTickets()) {
            String ticketNumber = ticketData.getTicketNumber();
            if (!TextUtil.isBlank((String)ticketNumber)) {
                ticketNumbers.add(ticketNumber);
            }
            for (MCONumber mcoNumber : ticketData.getMcoNumbers()) {
                ticketNumber = mcoNumber.getTicketNumber();
                if (TextUtil.isBlank((String)ticketNumber)) continue;
                ticketNumbers.add(ticketNumber);
            }
        }
        doc.getTicketNumbers().addAll(ticketNumbers);
        byte[] content = (byte[])ctx.getMandatoryObject((Enum)IBusParsersContextKeys.DOCUMENT_CONTENT);
        doc.setContent(content);
        ctx.putObject((Enum)IBusParsersContextKeys.REGISTRING_DOCUMENTS_LIST, Collections.singletonList(doc));
    }
}

