/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.amadeus.ibus.processors.registration;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.parsers.model.amadeus.AmadeusExchangeDocument;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public class AmadeusHandleRegisterExchangeDocumentAdvice
extends BaseAdvice {
    public boolean handleException(Throwable e, MessageContext context) throws Exception {
        if (ExceptionUtil.isInterruptedError((Throwable)e)) {
            this.log.warn("interrupted exception occurred", e);
            context.putObject((Enum)IBusParsersContextKeys.INTERRUPTED_EXCEPTION_OCCURRED, (Object)Boolean.TRUE);
        }
        context.addMessage(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438", (Throwable)e, (Object[])new Object[]{e.getMessage()}));
        return true;
    }

    public void after(MessageContext context) throws Exception {
        Collection messages = context.getMessagesReadOnly();
        Boolean interruptedExceptionOccurred = (Boolean)context.getObject((Enum)IBusParsersContextKeys.INTERRUPTED_EXCEPTION_OCCURRED);
        if (MessageHelper.hasMessages((Collection)messages, (MessageType)MessageType.ERROR)) {
            ExchangeFile file = (ExchangeFile)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_FILE);
            String checkSum = (String)context.getObject((Enum)IBusParsersContextKeys.CHECK_SUM);
            if (checkSum == null) {
                checkSum = MiscUtil.getCheckSum((byte[])file.getContent());
            }
            AmadeusExchangeDocument exchangeDocument = new AmadeusExchangeDocument();
            exchangeDocument.setContentType(ContentType.XML);
            exchangeDocument.setContent(new String(file.getContent(), StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8));
            exchangeDocument.setLocation(file.getLocation());
            exchangeDocument.setCreated(file.getCreated());
            exchangeDocument.setType(file.getType());
            exchangeDocument.setCheckSum(checkSum);
            exchangeDocument.setStatus(Boolean.TRUE.equals(interruptedExceptionOccurred) ? ProcessingStatus.UNPROCESSED : ProcessingStatus.ERROR);
            exchangeDocument.getMessages().clear();
            exchangeDocument.getMessages().addAll(messages);
            EntityStorage.get().save(EntityContainer.create((BaseEntity)exchangeDocument), true);
        }
    }
}

