/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.common;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.parsers.galileo.ibus.IbusParserGalileoContextKeys;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.BaseMirSectionParser;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirA02SectionParser;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirA04SectionParser;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirA07SectionParser;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirA08SectionParser;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirA09SectionParser;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirA10SectionParser;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirA11SectionParser;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirA12SectionParser;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirA14SectionParser;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirA23SectionParser;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirHeaderSectionParser;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;
import java.util.ArrayList;
import java.util.List;

public class MirFileParserProcessor
extends BaseProcessor {
    private final List<BaseMirSectionParser> parsers = new ArrayList<BaseMirSectionParser>();

    public MirFileParserProcessor() {
        this.parsers.add(new MirHeaderSectionParser());
        this.parsers.add(new MirA02SectionParser());
        this.parsers.add(new MirA04SectionParser());
        this.parsers.add(new MirA07SectionParser());
        this.parsers.add(new MirA08SectionParser());
        this.parsers.add(new MirA09SectionParser());
        this.parsers.add(new MirA10SectionParser());
        this.parsers.add(new MirA11SectionParser());
        this.parsers.add(new MirA12SectionParser());
        this.parsers.add(new MirA14SectionParser());
        this.parsers.add(new MirA23SectionParser());
    }

    public void process(MessageContext ctx) throws Exception {
        String[] sections;
        byte[] content = (byte[])ctx.getMandatoryObject((Enum)IBusParsersContextKeys.DOCUMENT_CONTENT);
        MirFile file = new MirFile();
        ctx.putObject((Enum)IbusParserGalileoContextKeys.MIR_FILE, (Object)file);
        String contentStr = new String(content, "utf-8");
        for (String section : sections = contentStr.contains("\r\n\r\n") ? contentStr.split("\r\n\r\n") : contentStr.split("\r\r")) {
            for (BaseMirSectionParser parser : this.parsers) {
                if (!section.startsWith(parser.getSectionId())) continue;
                String[] subsections = section.contains("\r\n") ? section.split("\r\n") : section.split("\r");
                Pair<Integer> numOfCarriageReturn = parser.getNumOfCarrierReturns();
                int n = 0;
                while (n < subsections.length) {
                    ArrayList<String> subcontent = new ArrayList<String>();
                    int m = 0;
                    for (m = 0; m <= (Integer)numOfCarriageReturn.getFirst(); ++m) {
                        subcontent.add(subsections[n]);
                        ++n;
                    }
                    while (n < subsections.length && !subsections[n].startsWith(parser.getSectionId())) {
                        subcontent.add(subsections[n]);
                        if (m > (Integer)numOfCarriageReturn.getLast()) {
                            throw Xeption.forEndUser((String)("\u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0441\u0435\u043a\u0446\u0438\u0438 " + parser.getSectionId()), (Object[])new Object[0]);
                        }
                        ++n;
                        ++m;
                    }
                    String subsection = CollectionUtil.collectionToString(subcontent, (String)"\r", (boolean)false);
                    parser.process(file, subsection);
                }
                break block1;
            }
        }
    }
}

