/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal;

import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirFixedFieldDescription;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirVariableFieldDescription;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;
import com.gridnine.xtrip.server.parsers.galileo.model.MirSection;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseMirSectionParser<S extends MirSection> {
    protected List<MirFixedFieldDescription<S>> fixedFields = new ArrayList<MirFixedFieldDescription<S>>();
    protected List<MirVariableFieldDescription<S>> variableFields = new ArrayList<MirVariableFieldDescription<S>>();

    public abstract String getSectionId();

    public abstract void process(MirFile var1, String var2) throws Exception;

    public abstract Pair<Integer> getNumOfCarrierReturns();

    protected void processSection(S section, String sectionContent) throws Exception {
        int cursor;
        int lastFixedSymbol = 0;
        int length = sectionContent.length();
        for (MirFixedFieldDescription<S> field : this.fixedFields) {
            int start = field.getStart();
            int end = start + field.getLength();
            if (length <= start) continue;
            if (end > length) {
                end = length;
            }
            if (lastFixedSymbol < end) {
                lastFixedSymbol = end;
            }
            String content = sectionContent.substring(start, end);
            content = content.trim();
            field.getUpdater().update(section, TextUtil.isBlank((String)content) ? null : content);
        }
        int lastStart = lastFixedSymbol;
        MirVariableFieldDescription<S> lastDescr = null;
        block1: for (cursor = lastFixedSymbol; cursor < length; ++cursor) {
            for (MirVariableFieldDescription<S> field : this.variableFields) {
                if (!this.startsWith(cursor, sectionContent, field.getId())) continue;
                if (lastDescr != null) {
                    String value = sectionContent.substring(lastStart, cursor - lastStart > lastDescr.getMaxLength() ? lastStart + lastDescr.getMaxLength() : cursor);
                    if (lastDescr.isTrimContent()) {
                        value = value.trim();
                    }
                    lastDescr.getUpdater().update(section, value);
                }
                lastDescr = field;
                lastStart = cursor = cursor + field.getId().length() + 1;
                continue block1;
            }
        }
        if (lastDescr != null) {
            if (lastStart >= sectionContent.length()) {
                lastDescr.getUpdater().update(section, "");
            } else {
                String value = sectionContent.substring(lastStart, cursor - lastStart > lastDescr.getMaxLength() ? lastStart + lastDescr.getMaxLength() : cursor);
                if (lastDescr.isTrimContent()) {
                    value = value.trim();
                }
                lastDescr.getUpdater().update(section, value);
            }
        }
    }

    private boolean startsWith(int cursor, String sectionContent, String id) {
        int sectionLength = sectionContent.length();
        int idLength = id.length();
        for (int n = 0; n <= idLength; ++n) {
            if (cursor + n >= sectionLength) {
                return false;
            }
            if (!(n == idLength ? sectionContent.charAt(cursor + n) != ':' : sectionContent.charAt(cursor + n) != id.charAt(n))) continue;
            return false;
        }
        return true;
    }
}

