/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal;

import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.BaseMirSectionParser;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirFixedFieldDescription;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirVariableFieldDescription;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA04Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;

public class MirA04SectionParser
extends BaseMirSectionParser<MirA04Section> {
    public MirA04SectionParser() {
        this.fixedFields.add(new MirFixedFieldDescription<MirA04Section>(3, 2, (section, value) -> section.setSegmentNumber(Integer.parseInt(value))));
        this.fixedFields.add(new MirFixedFieldDescription<MirA04Section>(5, 2, (section, value) -> section.setAirlineCode(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA04Section>(22, 4, (section, value) -> section.setFlightNumber(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA04Section>(26, 2, (section, value) -> section.setClassOfService(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA04Section>(28, 2, (section, value) -> section.setSegmentStatus(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA04Section>(30, 5, (section, value) -> section.setDepartureDateStr(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA04Section>(35, 5, (section, value) -> section.setDepartureTimeStr(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA04Section>(40, 5, (section, value) -> section.setArrivalTimeStr(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA04Section>(45, 1, (section, value) -> {
            if (!TextUtil.isBlank((String)value)) {
                section.setNextDayArrivalIndicator(Integer.valueOf(value));
            }
        }));
        this.fixedFields.add(new MirFixedFieldDescription<MirA04Section>(46, 3, (section, value) -> section.setDepartureCityCode(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA04Section>(62, 3, (section, value) -> section.setArrivalCityCode(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA04Section>(86, 3, (section, value) -> section.setBaggageAllowance(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA04Section>(89, 4, (section, value) -> section.setAircraftType(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA04Section>(96, 5, (section, value) -> {
            if (!TextUtil.isBlank((String)value)) {
                section.setNauticalMiles(Integer.valueOf(value));
            }
        }));
        this.variableFields.add(new MirVariableFieldDescription<MirA04Section>("ANL", 24, (section, value) -> section.setAffiliatedAirlineName(value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA04Section>("ACL", 24, (section, value) -> {}));
    }

    @Override
    public String getSectionId() {
        return "A04";
    }

    @Override
    public void process(MirFile file, String section) throws Exception {
        MirA04Section a04Section = new MirA04Section();
        file.getA04Sections().add(a04Section);
        this.processSection(a04Section, section);
    }

    @Override
    public Pair<Integer> getNumOfCarrierReturns() {
        return new Pair((Object)0, (Object)0);
    }
}

