/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal;

import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.BaseMirSectionParser;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirFixedFieldDescription;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirVariableFieldDescription;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA07Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;

public class MirA07SectionParser
extends BaseMirSectionParser<MirA07Section> {
    public MirA07SectionParser() {
        this.fixedFields.add(new MirFixedFieldDescription<MirA07Section>(3, 2, (section, value) -> section.setSectionIndicator(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA07Section>(5, 3, (section, value) -> section.setBaseFareCurrencyCode(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA07Section>(8, 12, (section, value) -> section.setBaseFareAmountStr(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA07Section>(20, 3, (section, value) -> section.setTotalCurrencyCode(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA07Section>(23, 12, (section, value) -> section.setTotalAmountStr(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA07Section>(35, 3, (section, value) -> section.setEquivalentAmountCurrencyCode(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA07Section>(38, 12, (section, value) -> section.setEquivalentAmountStr(value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA07Section>("T1", 10, (section, value) -> section.setTax1(value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA07Section>("T2", 10, (section, value) -> section.setTax2(value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA07Section>("T3", 10, (section, value) -> section.setTax3(value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA07Section>("T4", 10, (section, value) -> section.setTax4(value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA07Section>("T5", 10, (section, value) -> section.setTax5(value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA07Section>("IT", 120, (section, value) -> {
            if (value != null) {
                for (String val : value.split("\\s")) {
                    if (TextUtil.isBlank((String)val)) continue;
                    section.getIndividualTaxes().add(val.trim());
                }
            }
        }));
    }

    @Override
    public String getSectionId() {
        return "A07";
    }

    @Override
    public void process(MirFile file, String section) throws Exception {
        MirA07Section a07Section = new MirA07Section();
        file.getA07Sections().add(a07Section);
        this.processSection(a07Section, section);
    }

    @Override
    public Pair<Integer> getNumOfCarrierReturns() {
        return new Pair((Object)0, (Object)1);
    }
}

