/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal;

import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.BaseMirSectionParser;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirFixedFieldDescription;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirParserHelper;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirVariableFieldDescription;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA08Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;

public class MirA08SectionParser
extends BaseMirSectionParser<MirA08Section> {
    public MirA08SectionParser() {
        this.fixedFields.add(new MirFixedFieldDescription<MirA08Section>(3, 2, (section, value) -> section.setFareSectionId(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA08Section>(5, 2, (section, value) -> section.setSegmentNumber(Integer.parseInt(value))));
        this.fixedFields.add(new MirFixedFieldDescription<MirA08Section>(7, 8, (section, value) -> section.setFareBasisCode(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA08Section>(23, 7, (section, value) -> section.setNotValidBefore(MirParserHelper.parseLocalDate(value))));
        this.fixedFields.add(new MirFixedFieldDescription<MirA08Section>(30, 7, (section, value) -> section.setNotValidAfter(MirParserHelper.parseLocalDate(value))));
        this.variableFields.add(new MirVariableFieldDescription<MirA08Section>("EF", 50, (section, value) -> section.setFullEndorsement(value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA08Section>("F", 15, (section, value) -> section.setFullFareBasis(value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA08Section>("E", 25, (section, value) -> section.getBriefEndorsements().add(value)));
    }

    @Override
    public String getSectionId() {
        return "A08";
    }

    @Override
    public void process(MirFile file, String section) throws Exception {
        MirA08Section a08Section = new MirA08Section();
        file.getA08Sections().add(a08Section);
        this.processSection(a08Section, section);
    }

    @Override
    public Pair<Integer> getNumOfCarrierReturns() {
        return new Pair((Object)0, (Object)1);
    }
}

