/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal;

import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.BaseMirSectionParser;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirFixedFieldDescription;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirParserHelper;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirVariableFieldDescription;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA10Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;
import java.math.BigDecimal;

public class MirA10SectionParser
extends BaseMirSectionParser<MirA10Section> {
    public MirA10SectionParser() {
        this.fixedFields.add(new MirFixedFieldDescription<MirA10Section>(3, 2, (section, value) -> section.setPassengerNumber(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA10Section>(5, 7, (section, value) -> section.setOriginallyIssued(MirParserHelper.parseLocalDate(value))));
        this.fixedFields.add(new MirFixedFieldDescription<MirA10Section>(79, 1, (section, value) -> section.setExchangeType(value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA10Section>("TI", 18, (section, value) -> section.setOriginalTicketNumber(value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA10Section>("T1", 10, (section, value) -> section.setTax1(value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA10Section>("T2", 10, (section, value) -> section.setTax2(value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA10Section>("T3", 10, (section, value) -> section.setTax3(value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA10Section>("T4", 10, (section, value) -> section.setTax4(value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA10Section>("T5", 10, (section, value) -> section.setTax5(value)));
    }

    @Override
    public String getSectionId() {
        return "A10";
    }

    @Override
    public void process(MirFile file, String section) throws Exception {
        String totalExchange;
        MirA10Section a10Section = new MirA10Section();
        file.getA10Sections().add(a10Section);
        this.processSection(a10Section, section);
        String[] subsections = section.split("\r");
        String subsection = subsections[2];
        String addCollect = subsection.substring(subsection.length() - 12);
        if (!TextUtil.isBlank((String)addCollect)) {
            a10Section.setAddCollect(new BigDecimal(addCollect));
        }
        if (!TextUtil.isBlank((String)(totalExchange = subsection.substring(subsection.length() - 24, subsection.length() - 12)))) {
            a10Section.setExchangeTotal(new BigDecimal(totalExchange));
        }
    }

    @Override
    public Pair<Integer> getNumOfCarrierReturns() {
        return new Pair((Object)1, (Object)4);
    }
}

