/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal;

import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.BaseMirSectionParser;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirFixedFieldDescription;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirParserHelper;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirVariableFieldDescription;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA23Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;
import com.gridnine.xtrip.server.parsers.galileo.model.MirSection;
import java.math.BigDecimal;

public class MirA23SectionParser
extends BaseMirSectionParser<MirA23Section> {
    private MirA23BFSectionParser bfSectionParser = new MirA23BFSectionParser();
    private MirA23RASectionParser raSectionParser = new MirA23RASectionParser();

    public MirA23SectionParser() {
        this.fixedFields.add(new MirFixedFieldDescription<MirA23Section>(3, 13, (section, value) -> section.setTicketNumber(value)));
        this.fixedFields.add(new MirFixedFieldDescription<MirA23Section>(32, 7, (section, value) -> section.setRefundDate(MirParserHelper.parseLocalDate(value))));
        this.fixedFields.add(new MirFixedFieldDescription<MirA23Section>(48, 33, (section, value) -> section.setTravellerName(value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA23Section>("TI", 29, (section, value) -> section.setCouponsNumbers(value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA23Section>("BF", 120, (section, value) -> this.bfSectionParser.processSection(section, "BF:" + value)));
        this.variableFields.add(new MirVariableFieldDescription<MirA23Section>("IT", 120, (section, value) -> {
            if (!TextUtil.isBlank((String)value)) {
                String value2 = value;
                int idx = value.indexOf("\r");
                if (idx != -1) {
                    value2 = value.substring(0, idx);
                }
                for (String tax : value2.split("\\s")) {
                    if (TextUtil.isBlank((String)tax)) continue;
                    section.getIndividualRefundedTaxes().add(tax.trim());
                }
            }
        }));
        this.variableFields.add(new MirVariableFieldDescription<MirA23Section>("PF", 120, (section, value) -> {
            if (!TextUtil.isBlank((String)value)) {
                section.setPenaltyAmount(new BigDecimal(value.trim()));
            }
        }));
        this.variableFields.add(new MirVariableFieldDescription<MirA23Section>("RA", 120, false, (section, value) -> this.raSectionParser.processSection(section, "RA:" + value)));
    }

    @Override
    public String getSectionId() {
        return "A23";
    }

    @Override
    public void process(MirFile file, String section) throws Exception {
        MirA23Section a23Section = new MirA23Section();
        file.getA23Sections().add(a23Section);
        this.processSection(a23Section, section);
    }

    @Override
    public Pair<Integer> getNumOfCarrierReturns() {
        return new Pair((Object)1, (Object)10);
    }

    static class MirA23BFSectionParser
    extends BaseMirSectionParser<MirA23Section> {
        MirA23BFSectionParser() {
            this.variableFields.add(new MirVariableFieldDescription<MirA23Section>("T1", 13, (section, value) -> section.setRefundedTax1(value)));
            this.variableFields.add(new MirVariableFieldDescription<MirA23Section>("T2", 13, (section, value) -> section.setRefundedTax2(value)));
            this.variableFields.add(new MirVariableFieldDescription<MirA23Section>("T3", 13, (section, value) -> section.setRefundedTax3(value)));
        }

        @Override
        public String getSectionId() {
            return "BF:";
        }

        @Override
        public void process(MirFile file, String section) throws Exception {
            this.processSection((MirSection)file.getA23Sections().get(file.getA23Sections().size() - 1), section);
        }

        @Override
        public Pair<Integer> getNumOfCarrierReturns() {
            return new Pair((Object)0, (Object)0);
        }
    }

    static class MirA23RASectionParser
    extends BaseMirSectionParser<MirA23Section> {
        MirA23RASectionParser() {
            this.fixedFields.add(new MirFixedFieldDescription<MirA23Section>(11, 8, (section, value) -> {
                if (!TextUtil.isBlank((String)value)) {
                    section.setCashRefundedAmount(new BigDecimal(value.trim()));
                }
            }));
            this.fixedFields.add(new MirFixedFieldDescription<MirA23Section>(27, 8, (section, value) -> {
                if (!TextUtil.isBlank((String)value)) {
                    section.setCreditRefundedAmount(new BigDecimal(value.trim()));
                }
            }));
            this.fixedFields.add(new MirFixedFieldDescription<MirA23Section>(38, 8, (section, value) -> {
                if (!TextUtil.isBlank((String)value)) {
                    section.setTotalRefundedAmount(new BigDecimal(value.trim()));
                }
            }));
        }

        @Override
        public String getSectionId() {
            return "RA:";
        }

        @Override
        public void process(MirFile file, String section) throws Exception {
            this.processSection((MirSection)file.getA23Sections().get(file.getA23Sections().size() - 1), section);
        }

        @Override
        public Pair<Integer> getNumOfCarrierReturns() {
            return new Pair((Object)0, (Object)0);
        }
    }
}

