/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA02Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA10Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class MirParserHelper {
    private static final DateTimeFormatter dttf = DateTimeFormatter.ofPattern("ddMMMyyyyHHmm", Locale.ENGLISH);
    private static final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMMyyyy", Locale.ENGLISH);

    public static LocalDateTime parseLocalDateTime(String str) {
        if (TextUtil.isBlank((String)str)) {
            return null;
        }
        return LocalDateTime.parse(MirParserHelper.composeDate(str), dttf);
    }

    public static LocalDate parseLocalDate(String str) {
        if (TextUtil.isBlank((String)str)) {
            return null;
        }
        return LocalDate.parse(MirParserHelper.composeDate(str), dtf);
    }

    private static String composeDate(String str) {
        return String.format("%s%s20%s", str.substring(0, 2), TextUtil.camel((String)str.substring(2, 5)), str.substring(5));
    }

    public static PaymentType getPaymentType(String paymentType) {
        switch (paymentType) {
            case "S": {
                return PaymentType.CASH;
            }
            case "CC": {
                return PaymentType.CREDIT_CARD;
            }
        }
        return PaymentType.CASH;
    }

    public static ProductStatus getProductStatus(MirFile file, MirA02Section a02Section) {
        MirA10Section a10Section = file.getA10Sections().stream().filter(mirA10Section -> a02Section.getExchangeItemNumber().equals(mirA10Section.getPassengerNumber())).findFirst().orElse(null);
        if (a10Section != null) {
            return ProductStatus.EXCHANGE;
        }
        if ("V".equals(file.getHeader().getCommandUsed()) || "N".equals(file.getHeader().getCommandUsed())) {
            return ProductStatus.VOID;
        }
        return ProductStatus.SELL;
    }
}

