/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.IBusProfileContextKeys;
import com.gridnine.xtrip.common.parsers.galileo.ibus.IbusParserGalileoContextKeys;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

public class GalileoFillReservationParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        MirFile mirFile = (MirFile)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.MIR_FILE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.RESERVATION);
        BookingFile bookingFile = reservation.getBookingFile();
        bookingFile.setCreateDate(MiscUtil.toDate((LocalDate)mirFile.getHeader().getPnrCreationDate()));
        if (bookingFile.getCreateDate() == null) {
            bookingFile.setCreateDate(MiscUtil.toDate((LocalDateTime)mirFile.getHeader().getMirCreationDate()));
        }
        if (bookingFile.getCreateDate() == null) {
            bookingFile.setCreateDate(new Date());
        }
        EntityReference agencyRef = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.AGENCY);
        EntityReference subagencyRef = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.SUBAGENCY);
        EntityReference agentRef = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.AGENT);
        String agentCode = mirFile.getHeader().getIssuingAgentSign();
        EntityReference salesPointRef = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.SALES_POINT);
        if (bookingFile.getAgency() == null) {
            bookingFile.setAgency(agencyRef);
        }
        if (bookingFile.getCustomerProfile() == null) {
            EntityContainer clientCtr = ProfileHelper.getRetailProfileContainer();
            bookingFile.setCustomerProfile(clientCtr == null ? null : clientCtr.toReference());
        }
        reservation.setBookingAgent(agentRef);
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.GALILEO, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)mirFile.getHeader().getRecordLocator());
        CommonReservationGdsNameInfoHelper.setBookingAgentDutyCode((Reservation)reservation, (GdsName)GdsName.GALILEO, (String)agentCode);
        reservation.setResDate(MiscUtil.toDate((LocalDate)mirFile.getHeader().getPnrCreationDate()));
        reservation.setSalesPoint(salesPointRef);
        reservation.setSubagency(subagencyRef);
        reservation.setType(ReservationType.OFFLINE);
        if (reservation.getBookingFile().getCreateDate() == null) {
            reservation.setResDate(MiscUtil.toDate((LocalDate)mirFile.getHeader().getPnrCreationDate()));
        }
    }
}

