/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.galileo.ibus.IbusParserGalileoContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA02Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA07Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GalileoParserCreateFaresAndTaxesProcessor
extends BaseProcessor {
    private static Pattern ptt = Pattern.compile("([0-9]+)([A-Z][A-Z,0-9]+)");

    public void process(MessageContext ctx) throws Exception {
        BigDecimal equivalentFareValue;
        MirFile mirFile = (MirFile)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.MIR_FILE);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        MirA02Section a02Section = (MirA02Section)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.A2SECTION);
        MirA07Section a07Section = mirFile.getA07Sections().stream().filter(s -> s.getSectionIndicator().equals(a02Section.getFareItemNumber())).findFirst().orElse(null);
        this.updateTax(a07Section.getTax1(), product);
        this.updateTax(a07Section.getTax2(), product);
        this.updateTax(a07Section.getTax3(), product);
        this.updateTax(a07Section.getTax4(), product);
        this.updateTax(a07Section.getTax5(), product);
        if (!a07Section.getIndividualTaxes().isEmpty()) {
            product.getTaxes().removeIf(tax -> "XT".equals(tax.getCode()));
            for (String it : a07Section.getIndividualTaxes()) {
                this.updateTax(it, product);
            }
        }
        BigDecimal baseFareValue = new BigDecimal(a07Section.getBaseFareAmountStr());
        String baseFareCurrencyCode = a07Section.getBaseFareCurrencyCode();
        BigDecimal bigDecimal = equivalentFareValue = a07Section.getEquivalentAmountStr() == null ? null : new BigDecimal(a07Section.getEquivalentAmountStr());
        if (equivalentFareValue != null) {
            AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)equivalentFareValue);
        } else if (DictHelper.getEquivCurrency().equals(baseFareCurrencyCode)) {
            AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)baseFareValue);
        }
        if (baseFareValue != null && !TextUtil.isBlank((String)baseFareCurrencyCode)) {
            Money baseFare = new Money();
            baseFare.setCurrency(baseFareCurrencyCode);
            baseFare.setValue(baseFareValue);
            AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
        } else if (equivalentFareValue != null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0431\u0430\u0437\u043e\u0432\u044b\u0439 \u0442\u0430\u0440\u0438\u0444, \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0431\u0430\u0437\u043e\u0432\u043e\u0433\u043e \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d \u044d\u043a\u0432\u0438\u0432\u0430\u043b\u0435\u043d\u0442\u043d\u044b\u0439", (Object[])new Object[0]));
            Money baseFare = new Money();
            baseFare.setCurrency(DictHelper.getEquivCurrency());
            baseFare.setValue(equivalentFareValue);
            AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
        }
    }

    private void updateTax(String tax, Product product) {
        if (TextUtil.isBlank((String)tax)) {
            return;
        }
        Matcher matcher = ptt.matcher(tax);
        if (matcher.matches()) {
            Tax t = new Tax();
            t.setEquivalentAmount(new BigDecimal(matcher.group(1)));
            t.setCode(matcher.group(2));
            product.getTaxes().add(t);
        }
    }
}

