/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.process;

import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.galileo.ibus.IbusParserGalileoContextKeys;
import com.gridnine.xtrip.common.parsers.model.CalculationLineParsingResult;
import com.gridnine.xtrip.common.parsers.model.CalculationLineSegmentParsingResult;
import com.gridnine.xtrip.common.parsers.model.CalculationLineSegmentTariffParsingResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA04Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;
import com.gridnine.xtrip.server.parsers2.common.Parsers2GeneralHelper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;

public class GalileoParserCreateSegmentsProcessor
extends BaseProcessor {
    private static final DateTimeFormatter dttf = DateTimeFormatter.ofPattern("ddMMMyyyyHHmm", Locale.ENGLISH);

    public void process(MessageContext ctx) throws Exception {
        MirFile mirFile = (MirFile)ctx.getObject((Enum)IbusParserGalileoContextKeys.MIR_FILE);
        CalculationLineParsingResult parsingResult = (CalculationLineParsingResult)ctx.getObject((Enum)IBusParsersContextKeys.CALCULATION_LINE_PARSING_RESULT);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        if (this.isUseSegmentsInfoOnly(mirFile, parsingResult)) {
            this.processSegmentsInfoOnly(mirFile, product, ctx);
            return;
        }
        this.updateSegmentInfoByCalculationLine(mirFile, parsingResult, product, ctx);
    }

    private void processSegmentsInfoOnly(MirFile mirFile, Product product, MessageContext ctx) {
        int segNo = 0;
        for (MirA04Section segmentData : mirFile.getA04Sections()) {
            ++segNo;
            if (this.isVoidSegment(segmentData)) continue;
            SegmentTariff segmentTariff = new SegmentTariff();
            product.getSegmentTariffs().add(segmentTariff);
            Segment segment = new Segment();
            segmentTariff.getSegments().add(segment);
            segment.setAirlineLocator(mirFile.getHeader().getRecordLocator());
            DictionaryReference<GeoLocation> departureLocation = this.findAirport(segmentData.getDepartureCityCode(), segNo, ctx);
            segment.setDepartureLocation(departureLocation);
            DictionaryReference<GeoLocation> arrivalLocation = this.findAirport(segmentData.getArrivalCityCode(), segNo, ctx);
            segment.setArriveLocation(arrivalLocation);
            segment.setAirline(Parsers2GeneralHelper.findAirline((String)segmentData.getAirlineCode(), (int)segNo, (MessageContext)ctx));
            segment.setClassOfSvcCode(segmentData.getClassOfService());
            this.updateFareBasis(segment, mirFile, segNo, ctx);
            segment.setFlightNo(segmentData.getFlightNumber());
            LocalDateTime start = this.calculateStartDate(segmentData.getDepartureDateStr(), segmentData.getDepartureTimeStr(), mirFile.getHeader().getPnrLastChangeDate(), mirFile.getHeader().getMirCreationDate());
            segment.setStartDate(MiscUtil.toDate((LocalDateTime)start));
            segment.setEndDate(this.calculateEndDate(start, segmentData.getArrivalTimeStr(), segmentData.getNextDayArrivalIndicator()));
            segment.setRecordNumber(segNo);
            segment.setLuggageInfo(AirProductHelper.parseLuggageInfo((String)segmentData.getBaggageAllowance()));
        }
    }

    private void updateFareBasis(Segment segment, MirFile mirFile, int segNo, MessageContext ctx) {
        String fareBasis = mirFile.getA08Sections().stream().filter(s -> s.getSegmentNumber() == segNo).map(s -> s.getFullFareBasis()).findFirst().orElse(null);
        if (fareBasis == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0430 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c farebasis", (Object[])new Object[]{Integer.toString(segNo)}));
            return;
        }
        segment.setFareBasis(fareBasis);
    }

    private Date calculateEndDate(LocalDateTime start, String arrivalTimeStr, Integer nextDayArrivalIndicator) {
        if (TextUtil.isBlank((String)arrivalTimeStr) || start == null) {
            return null;
        }
        int arrivalHour = Integer.parseInt(arrivalTimeStr.length() == 3 ? arrivalTimeStr.substring(0, 1) : arrivalTimeStr.substring(0, 2));
        int arrivalMinute = Integer.parseInt(arrivalTimeStr.length() == 3 ? arrivalTimeStr.substring(1) : arrivalTimeStr.substring(2));
        LocalDateTime result = LocalDateTime.of(start.getYear(), start.getMonth(), start.getDayOfMonth(), arrivalHour, arrivalMinute);
        switch (nextDayArrivalIndicator) {
            case 1: {
                result = result.plusDays(-1L);
                break;
            }
            case 3: {
                result = result.plusDays(1L);
                break;
            }
            case 4: {
                result = result.plusDays(2L);
            }
        }
        return MiscUtil.toDate((LocalDateTime)result);
    }

    private LocalDateTime calculateStartDate(String departureDateStr, String departureTimeStr, LocalDate pnrLastChangeDate, LocalDateTime mirCreationDate) {
        if (TextUtil.isBlank((String)departureDateStr) || TextUtil.isBlank((String)departureTimeStr)) {
            return null;
        }
        int year = pnrLastChangeDate == null ? mirCreationDate.get(ChronoField.YEAR) : pnrLastChangeDate.get(ChronoField.YEAR);
        LocalDateTime res = this.calculateDate(departureDateStr, departureTimeStr, year);
        if (res.isAfter(LocalDateTime.now())) {
            return res;
        }
        return this.calculateDate(departureDateStr, departureTimeStr, year);
    }

    private LocalDateTime calculateDate(String departureDateStr, String departureTimeStr, int year) {
        return LocalDateTime.parse(String.format("%s%s%s%s", departureDateStr.substring(0, 2), TextUtil.camel((String)departureDateStr.substring(2, 5)), Integer.toString(year), departureTimeStr), dttf);
    }

    private void updateSegmentInfoByCalculationLine(MirFile mirFile, CalculationLineParsingResult parsingResult, Product product, MessageContext ctx) throws Exception {
        String calculationCurrencyCode = parsingResult.getCalculationCurrencyCode();
        boolean ignoreFares = false;
        ArrayList<ProductFare> fares = new ArrayList<ProductFare>();
        int idx = 0;
        int segNo = 0;
        List<MirA04Section> a04Sections = mirFile.getA04Sections();
        for (CalculationLineSegmentTariffParsingResult st : parsingResult.getSegmentTariffs()) {
            Money money;
            String currencyCode = st.getCurrencyCode() == null ? calculationCurrencyCode : st.getCurrencyCode();
            SegmentTariff segmentTariff = new SegmentTariff();
            product.getSegmentTariffs().add(segmentTariff);
            ProductFare fare = new ProductFare();
            fares.add(fare);
            fare.setSegmentTariff(segmentTariff);
            BigDecimal tariff = st.getTariff();
            if (currencyCode == null || tariff == null) {
                ignoreFares = true;
            } else if ("NUC".equals(currencyCode)) {
                fare.setNucFare(tariff);
                fare.setRoe(parsingResult.getRoe());
            } else if (DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB").equals(currencyCode)) {
                fare.setEquivalentFare(tariff);
                money = new Money();
                money.setCurrency(DictHelper.getEquivCurrency());
                money.setValue(tariff);
                fare.setBaseFare(money);
            } else {
                money = new Money();
                money.setCurrency(currencyCode);
                money.setValue(tariff);
                fare.setBaseFare(money);
            }
            for (CalculationLineSegmentParsingResult seg : st.getSegments()) {
                if (a04Sections.size() > segNo) {
                    MirA04Section segmentData = a04Sections.get(segNo);
                    ++segNo;
                    if (this.isVoidSegment(segmentData)) continue;
                    Segment segment = new Segment();
                    segmentTariff.getSegments().add(segment);
                    segment.setAirlineLocator(mirFile.getHeader().getRecordLocator());
                    DictionaryReference<GeoLocation> departureLocation = this.findAirport(segmentData.getDepartureCityCode(), segNo, ctx);
                    segment.setDepartureLocation(departureLocation);
                    DictionaryReference<GeoLocation> arrivalLocation = this.findAirport(segmentData.getArrivalCityCode(), segNo, ctx);
                    segment.setArriveLocation(arrivalLocation);
                    segment.setAirline(Parsers2GeneralHelper.findAirline((String)segmentData.getAirlineCode(), (int)segNo, (MessageContext)ctx));
                    segment.setClassOfSvcCode(segmentData.getClassOfService());
                    this.updateFareBasis(segment, mirFile, segNo, ctx);
                    segment.setFlightNo(segmentData.getFlightNumber());
                    LocalDateTime startDate = this.calculateStartDate(segmentData.getDepartureDateStr(), segmentData.getDepartureTimeStr(), mirFile.getHeader().getPnrLastChangeDate(), mirFile.getHeader().getMirCreationDate());
                    segment.setStartDate(MiscUtil.toDate((LocalDateTime)startDate));
                    segment.setEndDate(this.calculateEndDate(startDate, segmentData.getArrivalTimeStr(), segmentData.getNextDayArrivalIndicator()));
                    segment.setRecordNumber(segNo);
                    segment.setLuggageInfo(AirProductHelper.parseLuggageInfo((String)segmentData.getBaggageAllowance()));
                } else {
                    ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0432 \u043f\u043e\u043b\u0435\u0442\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u043f\u0438\u0441\u044c \u043f\u043e \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0443 {0}", (Object[])new Object[]{Integer.toString(idx + 1)}));
                }
                ++idx;
            }
        }
        if (!ignoreFares) {
            product.getFares().addAll(fares);
        }
    }

    private DictionaryReference<GeoLocation> findAirport(String airportCode, int segNo, MessageContext ctx) {
        List airportsRefs;
        if (TextUtil.isBlank((String)airportCode)) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0430\u044d\u0440\u043e\u043f\u043e\u0440\u0442\u0430 \u0432\u044b\u043b\u0435\u0442\u0430/\u043f\u0440\u0438\u043b\u0435\u0442\u0430 \u043d\u0430 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {0}", (Object[])new Object[]{Integer.toString(segNo)}));
            return null;
        }
        LinkedHashSet<GeoLocation> airports = new LinkedHashSet<GeoLocation>();
        LinkedHashSet<GeoLocation> cities = new LinkedHashSet<GeoLocation>();
        for (GeoLocation item : DictionaryCache.get().lookup(GeoLocation.class, airportCode, new String[]{CodeSystem.IATA.name()})) {
            if (item.getType() == LocationType.AIRPORT) {
                airports.add(item);
                continue;
            }
            if (item.getType() != LocationType.CITY) continue;
            cities.add(item);
        }
        if (!airports.isEmpty()) {
            if (airports.size() > 1) {
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0430\u044d\u043e\u043e\u043f\u043e\u0440\u0442\u043e\u0432 \u0432\u044b\u043b\u0435\u0442\u0430/\u043f\u0440\u0438\u043b\u0435\u0442\u0430 \u043d\u0430 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {0} \u043f\u043e \u043a\u043e\u0434\u0443 {1}", (Object[])new Object[]{Integer.toString(segNo), airportCode}));
            }
            return ((GeoLocation)airports.iterator().next()).toReference();
        }
        if (cities.isEmpty()) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0430\u044d\u0440\u043e\u043f\u043e\u0440\u0442/\u0433\u043e\u0440\u043e\u0434 \u0432\u044b\u043b\u0435\u0442\u0430/\u043f\u0440\u0438\u043b\u0435\u0442\u0430 \u043d\u0430 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {0}", (Object[])new Object[]{Integer.toString(segNo)}));
            return null;
        }
        GeoLocation loc = (GeoLocation)cities.iterator().next();
        if (cities.size() > 1) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0433\u043e\u0440\u043e\u0434\u043e\u0432 \u0432\u044b\u043b\u0435\u0442\u0430/\u043f\u0440\u0438\u043b\u0435\u0442\u0430 \u043d\u0430 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {0} \u043f\u043e \u043a\u043e\u0434\u0443 {1}", (Object[])new Object[]{Integer.toString(segNo), airportCode}));
        }
        if ((airportsRefs = DictHelper.findAirportsByCity((DictionaryReference)loc.toReference())).size() == 1) {
            return (DictionaryReference)airportsRefs.get(0);
        }
        return loc.toReference();
    }

    private boolean isUseSegmentsInfoOnly(MirFile mirFile, CalculationLineParsingResult parsingResult) {
        int count1 = 0;
        for (CalculationLineSegmentTariffParsingResult st : parsingResult.getSegmentTariffs()) {
            count1 += st.getSegments().size();
        }
        int count2 = 0;
        for (MirA04Section item : mirFile.getA04Sections()) {
            if (this.isVoidSegment(item)) continue;
            ++count2;
        }
        return count2 != count1;
    }

    private boolean isVoidSegment(MirA04Section item) {
        return "VOID".equals(item.getAirlineCode());
    }
}

