/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductSearchIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHelper;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedProductIndex;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.galileo.ibus.IbusParserGalileoContextKeys;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.SearchResultType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA02Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;

public class GalileoParserFindBookingProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        if (this.findByPnr(ctx)) {
            return;
        }
        if (this.findByRelatedNumber(ctx)) {
            return;
        }
        EntityContainer ctr = new EntityContainer(BookingFile.class);
        ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER, (Object)ctr);
        Reservation res = new Reservation();
        res.setBookingFile((BookingFile)ctr.getEntity());
        ((BookingFile)ctr.getEntity()).getReservations().add(res);
        ctx.putObject((Enum)IBusParsersContextKeys.RESERVATION, (Object)res);
        ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.NEW);
    }

    private boolean findByRelatedNumber(MessageContext ctx) {
        MirFile mirFile = (MirFile)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.MIR_FILE);
        String relatedTicketNumber = null;
        for (MirA02Section item : mirFile.getA02Sections()) {
            if (TextUtil.isBlank((String)item.getTicketNumber())) continue;
            relatedTicketNumber = item.getTicketNumber();
            break;
        }
        if (!mirFile.getA10Sections().isEmpty()) {
            relatedTicketNumber = mirFile.getA10Sections().get(0).getOriginalTicketNumber().substring(3, 13);
        }
        if (TextUtil.isBlank(relatedTicketNumber)) {
            return false;
        }
        Date changeDate = MiscUtil.toDate((LocalDate)mirFile.getHeader().getPnrLastChangeDate());
        if (changeDate == null) {
            changeDate = MiscUtil.toDate((LocalDateTime)mirFile.getHeader().getMirCreationDate());
        }
        if (changeDate == null) {
            throw Xeption.forEndUser((String)"\u0432 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f", (Object[])new Object[0]);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(changeDate);
        cal.add(1, -2);
        Date lowerBound = cal.getTime();
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(ProductSearchIndex.Property.issueDate.name());
        query.getPreferredProperties().add(ProductSearchIndex.Property.recordLocators.name());
        query.getPreferredProperties().add(ProductSearchIndex.Property.recordLocator.name());
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.systemNumber.name(), (Object)relatedTicketNumber));
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductSearchIndex.Property.issueDate.name(), (Object)lowerBound));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.status.name(), (Object)ProductStatus.SELL));
        query.getCriteria().getCriterions().add(SearchQueryHelper.getGdsNameSearchCriterionForProductSearchIndex((GdsName)GdsName.GALILEO));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductSearchIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        HashSet<EntityReference> bookings = new HashSet<EntityReference>();
        for (ProductSearchIndex item : EntityStorage.get().search(ProductSearchIndex.class, query).getData()) {
            bookings.add(item.getSource());
        }
        if (bookings.size() > 1) {
            throw Xeption.forEndUser((String)"\u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c {0} \u0441 \u0434\u0430\u0442\u043e\u0439 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u043e\u0437\u0434\u043d\u0435\u0435 {1}, \u0432\u044b\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u0445 \u0432 {2}", (Object[])new Object[]{relatedTicketNumber, lowerBound, GdsName.GALILEO});
        }
        EntityContainer ctr = null;
        if (!bookings.isEmpty()) {
            ctr = EntityStorage.get().resolve((EntityReference)bookings.iterator().next());
        } else {
            query = new SearchQuery();
            query.getPreferredProperties().add(ArchivedProductIndex.Property.issueDate.name());
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ArchivedProductIndex.Property.productNumber.name(), (Object)relatedTicketNumber));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ArchivedProductIndex.Property.status.name(), (Object)ProductStatus.SELL));
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ArchivedProductIndex.Property.issueDate.name(), (Object)lowerBound));
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ArchivedProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
            HashSet<EntityReference> archivedBookings = new HashSet<EntityReference>();
            for (ArchivedProductIndex item : EntityStorage.get().search(ArchivedProductIndex.class, query).getData()) {
                archivedBookings.add(item.getSource());
            }
            if (archivedBookings.isEmpty()) {
                return false;
            }
            HashSet<EntityReference> toUnarchive = new HashSet<EntityReference>();
            for (EntityReference item : archivedBookings) {
                EntityContainer bookingContainer = ArchivedBookingHelper.getBookingContainer((ArchivedBooking)((ArchivedBooking)EntityStorage.get().resolve(item).getEntity()));
                Product prod = this.findProduct((BookingFile)bookingContainer.getEntity(), relatedTicketNumber, lowerBound);
                if (prod == null) continue;
                toUnarchive.add(item);
            }
            if (toUnarchive.isEmpty()) {
                return false;
            }
            if (toUnarchive.size() > 1) {
                throw Xeption.forEndUser((String)"\u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443 {0} \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0431\u0438\u043b\u0435\u0442\u043e\u0432, \u0432\u044b\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u0445 \u043f\u043e\u0437\u0434\u043d\u0435\u0435 {1} \u0432 {2}", (Object[])new Object[]{relatedTicketNumber, lowerBound, GdsName.GALILEO});
            }
            ctr = BookingDao.unarchiveBookingFile((EntityReference)((EntityReference)toUnarchive.iterator().next()));
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0440\u0430\u0437\u0430\u0440\u0445\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0437\u0430\u043a\u0430\u0437 {0}", (Object[])new Object[]{ctr.toReference()}));
        }
        ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER, (Object)ctr);
        Product prod = this.findProduct((BookingFile)ctr.getEntity(), relatedTicketNumber, lowerBound);
        ctx.putObject((Enum)IBusParsersContextKeys.RESERVATION, (Object)prod.getReservation());
        ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.ALREADY_EXISTS);
        return true;
    }

    private Product findProduct(BookingFile entity, String relatedTicketNumber, Date lowerBound) {
        for (Reservation res : entity.getReservations()) {
            if (!CommonReservationGdsNameInfoHelper.containsGds((Reservation)res, (GdsName)GdsName.GALILEO)) continue;
            for (BaseProduct bp : res.getProducts()) {
                Product prod;
                if (!(bp instanceof Product) || (prod = (Product)bp).getStatus() != ProductStatus.SELL || !relatedTicketNumber.equals(prod.getSystemNumber()) || prod.getIssueDate() != null && !prod.getIssueDate().after(lowerBound)) continue;
                return prod;
            }
        }
        return null;
    }

    private boolean findByPnr(MessageContext ctx) {
        MirFile mirFile = (MirFile)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.MIR_FILE);
        String pnr = mirFile.getHeader().getRecordLocator();
        if (TextUtil.isBlank((String)pnr)) {
            throw Xeption.forEndUser((String)"\u0432 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 PNR", (Object[])new Object[0]);
        }
        Date creationDate = MiscUtil.toDate((LocalDateTime)mirFile.getHeader().getCreated());
        if (creationDate == null) {
            throw Xeption.forEndUser((String)"\u0432 \u043e\u0431\u043c\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", (Object[])new Object[0]);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(creationDate);
        cal.add(1, -2);
        Date lowerBound = cal.getTime();
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(ProductSearchIndex.Property.issueDate.name());
        query.getCriteria().getCriterions().add(SearchQueryHelper.getRecordLocatorSearchCriterionForProductSearchIndex((String)pnr));
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductSearchIndex.Property.issueDate.name(), (Object)lowerBound));
        query.getCriteria().getCriterions().add(SearchQueryHelper.getGdsNameSearchCriterionForProductSearchIndex((GdsName)GdsName.GALILEO));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductSearchIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        HashSet<EntityReference> bookings = new HashSet<EntityReference>();
        for (ProductSearchIndex item : EntityStorage.get().search(ProductSearchIndex.class, query).getData()) {
            bookings.add(item.getSource());
        }
        if (bookings.size() > 1) {
            throw Xeption.forEndUser((String)"\u0434\u043b\u044f pnr {0} \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0439 \u0441 \u0434\u0430\u0442\u043e\u0439 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u043e\u0437\u0434\u043d\u0435\u0435 {1}, \u0441\u0434\u0435\u043b\u0430\u043d\u043d\u044b\u0445 \u0432 {2}", (Object[])new Object[]{pnr, lowerBound, GdsName.GALILEO});
        }
        EntityContainer ctr = null;
        if (!bookings.isEmpty()) {
            ctr = EntityStorage.get().resolve((EntityReference)bookings.iterator().next());
        } else {
            query = new SearchQuery();
            query.getPreferredProperties().add(ArchivedProductIndex.Property.issueDate.name());
            query.getCriteria().getCriterions().add(SearchQueryHelper.getRecordLocatorSearchCriterionForArchivedProductIndex((String)pnr));
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ArchivedProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
            HashSet<EntityReference> archivedBookings = new HashSet<EntityReference>();
            for (ArchivedProductIndex item : EntityStorage.get().search(ArchivedProductIndex.class, query).getData()) {
                archivedBookings.add(item.getSource());
            }
            if (archivedBookings.isEmpty()) {
                return false;
            }
            HashSet<EntityReference> toUnarchive = new HashSet<EntityReference>();
            for (EntityReference item : archivedBookings) {
                if (item.getType().equals(BookingFile.class)) continue;
                EntityContainer bookingContainer = ArchivedBookingHelper.getBookingContainer((ArchivedBooking)((ArchivedBooking)EntityStorage.get().resolve(item).getEntity()));
                for (Reservation res : ((BookingFile)bookingContainer.getEntity()).getReservations()) {
                    if (!CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)res, (String)pnr, (GdsName)GdsName.GALILEO) || res.getResDate() != null && !res.getResDate().after(lowerBound)) continue;
                    toUnarchive.add(item);
                }
            }
            if (toUnarchive.isEmpty()) {
                return false;
            }
            if (toUnarchive.size() > 1) {
                throw Xeption.forEndUser((String)"\u0434\u043b\u044f pnr {0} \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0439 \u0441 \u0434\u0430\u0442\u043e\u0439 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u043e\u0437\u0434\u043d\u0435\u0435 {1}, \u0441\u0434\u0435\u043b\u0430\u043d\u043d\u044b\u0445 \u0432 {2}", (Object[])new Object[]{pnr, lowerBound, GdsName.GALILEO});
            }
            ctr = BookingDao.unarchiveBookingFile((EntityReference)((EntityReference)toUnarchive.iterator().next()));
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0440\u0430\u0437\u0430\u0440\u0445\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0437\u0430\u043a\u0430\u0437 {0}", (Object[])new Object[]{ctr.toReference()}));
        }
        ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER, (Object)ctr);
        for (Reservation item : ((BookingFile)ctr.getEntity()).getReservations()) {
            if (!CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)item, (String)pnr, (GdsName)GdsName.GALILEO)) continue;
            ctx.putObject((Enum)IBusParsersContextKeys.RESERVATION, (Object)item);
            ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.ALREADY_EXISTS);
            return true;
        }
        throw Xeption.forDeveloper((String)"internal error: product found but PNR absent, booking = {0} pnr = {1}", (Object[])new Object[]{ctr.toReference(), pnr});
    }
}

