/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.process;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.parsers.galileo.ibus.IbusParserGalileoContextKeys;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.SearchResultType;
import com.gridnine.xtrip.common.parsers.model.amadeus.IBusAmadeusParserContextKeys;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA02Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA10Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;
import java.util.ArrayList;

public class GalileoParserMergeExchangeProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        MirA02Section ticketData = (MirA02Section)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.A2SECTION);
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.RESERVATION);
        for (BaseProduct bp : res.getProducts()) {
            Product prod;
            if (!(bp instanceof Product) || (prod = (Product)bp).getStatus() != ProductStatus.SELL || !ticketData.getTicketNumber().equals(prod.getSystemNumber())) continue;
            ctx.putObject((Enum)IBusAmadeusParserContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.FALSE);
            return;
        }
        Product sell = null;
        MirFile file = (MirFile)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.MIR_FILE);
        MirA10Section a10Section = file.getA10Sections().stream().filter(mirA10Section -> ticketData.getExchangeItemNumber().equals(mirA10Section.getPassengerNumber())).findFirst().get();
        String originalTicketNumber = a10Section.getOriginalTicketNumber().substring(3, 13);
        for (BaseProduct bp : res.getProducts()) {
            Product prod;
            if (!(bp instanceof Product) || (prod = (Product)bp).getStatus() != ProductStatus.SELL || !prod.getSystemNumber().equals(originalTicketNumber)) continue;
            sell = prod;
        }
        if (sell == null) {
            throw Xeption.forEndUser((String)"\u0432 \u0437\u0430\u043a\u0430\u0437\u0435 {0} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0431\u0438\u043b\u0435\u0442 {1} \u043f\u0440\u0438\u043d\u044f\u0442\u044b\u0439 \u043a \u043e\u0431\u043c\u0435\u043d\u0443", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getRecordLocator((Reservation)res, (GdsName)GdsName.GALILEO, (RecordLocatorType)RecordLocatorType.DEFAULT), originalTicketNumber});
        }
        String pnr = (String)ctx.getObject((Enum)IBusParsersContextKeys.PNR);
        Product exchange = this.createExchange(sell);
        if (pnr != null && !CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)res, (String)pnr, (GdsName)GdsName.GALILEO)) {
            this.split(exchange, pnr);
        }
        ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_RESULT_TYPE, (Object)SearchResultType.NEW);
        ctx.putObject((Enum)IBusBookingContextKeys.PRODUCT, (Object)exchange);
        ctx.putObject((Enum)IbusParserGalileoContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void split(Product product, String newPnr) throws Exception {
        Reservation reservation = product.getReservation();
        BookingFile bf = reservation.getBookingFile();
        ArrayList products = new ArrayList(reservation.getProducts());
        reservation.setBookingFile(null);
        reservation.getProducts().clear();
        try {
            Reservation newReservation = (Reservation)XCloneHelper.clone((XCloneable)reservation, (boolean)true);
            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.GALILEO, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)newPnr);
            newReservation.setBookingFile(bf);
            bf.getReservations().add(newReservation);
            newReservation.getProducts().add(product);
            newReservation.getProducts().add(product.getPreviousProduct());
            newReservation.getProducts().add(product.getPreviousProduct().getPreviousProduct());
            products.remove(product);
            products.remove(product.getPreviousProduct());
            products.remove(product.getPreviousProduct().getPreviousProduct());
            product.setReservation(newReservation);
            product.getPreviousProduct().setReservation(newReservation);
            product.getPreviousProduct().getPreviousProduct().setReservation(newReservation);
        }
        finally {
            reservation.setBookingFile(bf);
            reservation.getProducts().addAll(products);
        }
    }

    private Product createExchange(Product sell) throws Exception {
        Product exchange = AirProductHelper.clone((Product)sell, (boolean)true);
        exchange.setStatus(ProductStatus.EXCHANGE);
        sell.setNextProduct(exchange);
        exchange.setPreviousProduct(sell);
        Product product = new Product();
        product.setStatus(ProductStatus.SELL);
        product.setProductCategory(ProductCategory.AIR);
        product.setTicketType(TicketType.OWN);
        product.setTraveller(sell.getTraveller());
        product.setReservation(sell.getReservation());
        sell.getReservation().getProducts().add(product);
        exchange.setNextProduct(product);
        product.setPreviousProduct(exchange);
        return product;
    }
}

