/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.process;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.parsers.galileo.ibus.IbusParserGalileoContextKeys;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA23Section;

public class GalileoParserMergeRefundProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        MirA23Section refundData = (MirA23Section)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.A23SECTION);
        String ticketNumber = refundData.getTicketNumber().substring(3);
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.RESERVATION);
        Product sell = null;
        for (BaseProduct prod : res.getProducts()) {
            Product product;
            if (!(prod instanceof Product) || !MiscUtil.equals((Object)(product = (Product)prod).getSystemNumber(), (Object)ticketNumber)) continue;
            if (product.getStatus() == ProductStatus.REFUND) {
                ctx.putObject((Enum)IbusParserGalileoContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.FALSE);
                return;
            }
            if (product.getStatus() != ProductStatus.SELL) continue;
            sell = product;
        }
        if (sell == null) {
            throw Xeption.forDeveloper((String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0438\u0441\u0445\u043e\u0434\u043d\u0443\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443 {0}", (Object[])new Object[]{refundData.getTicketNumber()});
        }
        Product product = AirProductHelper.clone(sell, (boolean)true);
        product.setContractRulesApplied(false);
        product.getPrepaymentDocuments().clear();
        product.getFopDetalizations().clear();
        product.setStatus(ProductStatus.REFUND);
        product.setPreviousProduct(sell);
        sell.setNextProduct(product);
        ctx.putObject((Enum)IBusBookingContextKeys.PRODUCT, (Object)product);
        ctx.putObject((Enum)IbusParserGalileoContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.TRUE);
    }
}

