/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.process;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.galileo.ibus.IbusParserGalileoContextKeys;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA02Section;
import com.gridnine.xtrip.server.parsers2.common.avia.Parsers2AviaHelper;
import java.util.Map;

public class GalileoParserMergeSellProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        MirA02Section ticketData = (MirA02Section)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.A2SECTION);
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.RESERVATION);
        Map travsMap = (Map)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.TRAVELLER_DATA_MAP);
        Traveller traveller = (Traveller)travsMap.get(ticketData.getPassengerName());
        Product product = null;
        for (BaseProduct bp : res.getProducts()) {
            if (!(bp instanceof Product)) continue;
            Product prod = (Product)bp;
            if ((prod.getStatus() == ProductStatus.SELL || prod.getStatus() == ProductStatus.VOID || prod.getStatus() == ProductStatus.REFUND) && ticketData.getTicketNumber().equals(prod.getSystemNumber())) {
                ctx.putObject((Enum)IbusParserGalileoContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.FALSE);
                return;
            }
            if (prod.getStatus() != ProductStatus.BOOKING || !prod.getTraveller().getUid().equals(traveller.getUid())) continue;
            product = prod;
            prod.setSystemNumber(ticketData.getTicketNumber());
            product.setStatus(ProductStatus.SELL);
            ctx.putObject((Enum)IbusParserGalileoContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.FALSE);
            return;
        }
        if (product == null) {
            product = new Product();
            product.setReservation(res);
            res.getProducts().add(product);
            product.setTraveller(traveller);
        }
        product.setStatus(ProductStatus.SELL);
        product.setProductCategory(ProductCategory.AIR);
        product.setTicketType(TicketType.OWN);
        if (product.getTraveller() == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0434\u043b\u044f \u0431\u0438\u043b\u0435\u0442\u0430 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430", (Object[])new Object[]{ticketData.getTicketNumber()}));
        }
        product.setPassengerType(Parsers2AviaHelper.getPassengerType((String)ticketData.getPassengerIdentificationCode()));
        if (product.getPassengerType() == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0434\u043b\u044f \u0431\u0438\u043b\u0435\u0442\u0430 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430, \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d {1}", (Object[])new Object[]{ticketData.getTicketNumber(), DictHelper.getAdultPassengerType()}));
        }
        product.setGdsCurrency(DictHelper.getEquivCurrency());
        ctx.putObject((Enum)IBusBookingContextKeys.PRODUCT, (Object)product);
        ctx.putObject((Enum)IbusParserGalileoContextKeys.TICKET_PROCESSING_ALLOWED, (Object)Boolean.TRUE);
    }
}

