/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.process;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.parsers.galileo.ibus.IbusParserGalileoContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA02Section;
import java.util.List;
import java.util.Map;

public class GalileoParserMergeTravellerProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map travs = (Map)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.TRAVELLER_DATA_MAP);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        MirA02Section section = (MirA02Section)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.A2SECTION);
        Traveller newTraveller = (Traveller)travs.get(section.getPassengerName());
        Traveller traveller = this.findTravellerByPassport(newTraveller, ((BookingFile)bookingCtr.getEntity()).getTravellers());
        if (traveller != null) {
            this.updateTraveller(traveller, newTraveller);
            travs.put(section.getPassengerName(), traveller);
            return;
        }
        traveller = this.findTravellerByName(newTraveller, ((BookingFile)bookingCtr.getEntity()).getTravellers());
        if (traveller != null) {
            this.updateTraveller(traveller, newTraveller);
            travs.put(section.getPassengerName(), traveller);
            return;
        }
        ((BookingFile)bookingCtr.getEntity()).getTravellers().add(newTraveller);
    }

    private Traveller findTravellerByName(Traveller fromAir, List<Traveller> travellers) {
        String name = fromAir.getName();
        if (TextUtil.isBlank((String)name)) {
            return null;
        }
        for (Traveller trav : travellers) {
            if (!TextUtil.isSame((String)trav.getName(), (String)name, (boolean)true)) continue;
            return trav;
        }
        return null;
    }

    private void updateTraveller(Traveller existing, Traveller fromAir) {
        fromAir.setUid(existing.getUid());
    }

    private Traveller findTravellerByPassport(Traveller fromAir, List<Traveller> travellers) {
        Passport passport = fromAir.getPassport();
        if (passport == null || passport.getNumber() == null) {
            return null;
        }
        for (Traveller trav : travellers) {
            if (trav.getPassport() == null || !passport.getNumber().equals(trav.getPassport().getNumber())) continue;
            return trav;
        }
        return null;
    }
}

