/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.parsers.galileo.ibus.process;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.IBusProfileContextKeys;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.galileo.ibus.IbusParserGalileoContextKeys;
import com.gridnine.xtrip.common.parsers.model.FopItem;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.galileo.ibus.common.internal.MirParserHelper;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA02Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirA10Section;
import com.gridnine.xtrip.server.parsers.galileo.model.MirFile;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;

public class GalileoParserUpdateExchangedProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        this.correctStandardFields(product.getPreviousProduct(), ctx);
        for (Object item : AirProductHelper.getContractRelations((Product)product.getPreviousProduct())) {
            if (GeneralProductHelper.getContractType((EntityReference)item.getDescription()) == ContractType.VENDOR) continue;
            item.getFops().clear();
        }
        PaymentType pt = null;
        for (ProductFop item : AirProductHelper.getVendorContractRelation((Product)product.getPreviousProduct()).getFops()) {
            if (item.getAmount() == null || item.getAmount().getValue() == null || item.getType() == PaymentType.TICKET || item.getType() == null) continue;
            pt = item.getType();
        }
        FopItem pi = new FopItem();
        pi.setPaymentType(pt == null ? PaymentType.CASH : pt);
        pi.setAmount(HandlersRegistry.get().findProductHandler(Product.class).calculateProductPrice((BaseProduct)product.getPreviousProduct(), ContractType.VENDOR).getTotal().negate());
        ctx.putObject((Enum)IBusParsersContextKeys.EXCHANGE_FOPS_DATA, Collections.singletonList(pi));
        MirFile mirFile = (MirFile)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.MIR_FILE);
        MirA02Section a02Section = (MirA02Section)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.A2SECTION);
        MirA10Section a10Section = mirFile.getA10Sections().stream().filter(sec -> sec.getPassengerNumber().equals(a02Section.getExchangeItemNumber())).findFirst().get();
        BigDecimal addAmmount = a10Section.getAddCollect();
        if (addAmmount != null && addAmmount.compareTo(BigDecimal.ZERO) > 0) {
            PaymentType pt2 = PaymentType.CASH;
            if (mirFile.getA11Section() != null) {
                pt2 = MirParserHelper.getPaymentType(mirFile.getA11Section().getPaymentType());
            }
            FopItem pi2 = new FopItem();
            pi2.setPaymentType(pt2);
            pi2.setAmount(addAmmount);
            ctx.putObject((Enum)IBusParsersContextKeys.FOPS_DATA, Collections.singletonList(pi2));
        }
    }

    private void correctStandardFields(Product exchange, MessageContext ctx) throws Exception {
        MirFile mirFile = (MirFile)ctx.getMandatoryObject((Enum)IbusParserGalileoContextKeys.MIR_FILE);
        exchange.setIssueDate(mirFile.getHeader().getPnrLastChangeDate() == null ? MiscUtil.toDate((LocalDateTime)mirFile.getHeader().getMirCreationDate()) : MiscUtil.toDate((LocalDate)mirFile.getHeader().getPnrLastChangeDate()));
        exchange.setContractRulesApplied(false);
        exchange.setChecked(false);
        String agentCode = (String)ctx.getObject((Enum)IBusProfileContextKeys.AGENT_CODE);
        exchange.setCashierCode(agentCode);
        EntityReference agent = (EntityReference)ctx.getObject((Enum)IBusProfileContextKeys.AGENT);
        exchange.setCashier(agent);
        exchange.setPcc((String)ctx.getObject((Enum)IBusProfileContextKeys.PCC));
        exchange.setSalesPoint(exchange.getNextProduct().getSalesPoint());
        AirProductHelper.getSalesChain((Product)exchange).copyFrom((BaseEntity)AirProductHelper.getSalesChain((Product)exchange.getNextProduct()), false, new HashMap());
    }
}

